/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.core.ConnectionString;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.UnableToConnectException;
import com.mysql.cj.core.io.NetworkResources;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.fabric.jdbc.FabricMySQLConnectionProxy;
import com.mysql.cj.jdbc.AbandonedConnectionCleanupThread;
import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.JdbcPropertySetImpl;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.ha.FailoverConnectionProxy;
import com.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import com.mysql.cj.jdbc.ha.ReplicationConnectionProxy;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class NonRegisteringDriver
implements Driver {
    protected static final ConcurrentHashMap<ConnectionPhantomReference, ConnectionPhantomReference> connectionPhantomRefs = new ConcurrentHashMap();
    protected static final ReferenceQueue<ConnectionImpl> refQueue = new ReferenceQueue();

    public static String getOSName() {
        return Constants.OS_NAME;
    }

    public static String getPlatform() {
        return Constants.OS_ARCH;
    }

    static int getMajorVersionInternal() {
        return StringUtils.safeIntParse("6");
    }

    static int getMinorVersionInternal() {
        return StringUtils.safeIntParse("0");
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        try {
            return ConnectionString.parseUrl(url, null) != null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            try {
                ConnectionString conStr = new ConnectionString(url, info);
                if (conStr.getProperties() == null) {
                    return null;
                }
                switch (conStr.connectionStringType) {
                    case LOADBALANCING_CONNECTION: {
                        return LoadBalancedConnectionProxy.createProxyInstance(conStr);
                    }
                    case FAILOVER_CONNECTION: {
                        return FailoverConnectionProxy.createProxyInstance(conStr);
                    }
                    case REPLICATION_CONNECTION: {
                        return ReplicationConnectionProxy.createProxyInstance(conStr);
                    }
                    case FABRIC_CONNECTION: {
                        return new FabricMySQLConnectionProxy(conStr);
                    }
                }
                return ConnectionImpl.getInstance(conStr, ConnectionString.host(conStr.getProperties()), ConnectionString.port(conStr.getProperties()), conStr.getProperties());
            }
            catch (CJException ex) {
                throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("NonRegisteringDriver.17", new Object[]{ex.toString()}), ex);
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected static void trackConnection(JdbcConnection newConn) {
        ConnectionPhantomReference phantomRef = new ConnectionPhantomReference((ConnectionImpl)newConn, refQueue);
        connectionPhantomRefs.put(phantomRef, phantomRef);
    }

    @Override
    public int getMajorVersion() {
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    @Override
    public int getMinorVersion() {
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            if (info == null) {
                info = new Properties();
            }
            if (url != null && url.startsWith(ConnectionString.ConnectionStringType.SINGLE_CONNECTION.urlPrefix)) {
                info = ConnectionString.parseUrl(url, info);
            }
            DriverPropertyInfo hostProp = new DriverPropertyInfo("HOST", info.getProperty("HOST"));
            hostProp.required = true;
            hostProp.description = Messages.getString("NonRegisteringDriver.3");
            DriverPropertyInfo portProp = new DriverPropertyInfo("PORT", info.getProperty("PORT", "3306"));
            portProp.required = false;
            portProp.description = Messages.getString("NonRegisteringDriver.7");
            DriverPropertyInfo dbProp = new DriverPropertyInfo("DBNAME", info.getProperty("DBNAME"));
            dbProp.required = false;
            dbProp.description = "Database name";
            DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
            userProp.required = true;
            userProp.description = Messages.getString("NonRegisteringDriver.13");
            DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
            passwordProp.required = true;
            passwordProp.description = Messages.getString("NonRegisteringDriver.16");
            DriverPropertyInfo[] dpi = new JdbcPropertySetImpl().exposeAsDriverPropertyInfo(info, 5);
            dpi[0] = hostProp;
            dpi[1] = portProp;
            dpi[2] = dbProp;
            dpi[3] = userProp;
            dpi[4] = passwordProp;
            return dpi;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        AbandonedConnectionCleanupThread referenceThread = new AbandonedConnectionCleanupThread();
        referenceThread.setDaemon(true);
        referenceThread.start();
    }

    static class ConnectionPhantomReference
    extends PhantomReference<ConnectionImpl> {
        private NetworkResources io;

        ConnectionPhantomReference(ConnectionImpl connectionImpl, ReferenceQueue<ConnectionImpl> q) {
            super(connectionImpl, q);
            this.io = connectionImpl.getSession().getNetworkResources();
        }

        void cleanup() {
            if (this.io != null) {
                try {
                    this.io.forceClose();
                }
                finally {
                    this.io = null;
                }
            }
        }
    }
}

