/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class ValueComparison
extends BinaryExpression
implements ComparisonExpression,
Negatable {
    private BooleanValue resultWhenEmpty = null;
    private boolean needsRuntimeCheck;

    public ValueComparison(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    @Override
    public String getExpressionName() {
        return "ValueComparison";
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        ItemType t1;
        ItemType t0 = this.getLhsExpression().getItemType().getPrimitiveItemType();
        if (!(t0 instanceof BuiltInAtomicType)) {
            t0 = BuiltInAtomicType.ANY_ATOMIC;
        }
        if (!((t1 = this.getRhsExpression().getItemType().getPrimitiveItemType()) instanceof BuiltInAtomicType)) {
            t1 = BuiltInAtomicType.ANY_ATOMIC;
        }
        return GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)t0, (BuiltInAtomicType)t1, this.getStringCollator(), this.getConfiguration().getConversionContext());
    }

    @Override
    public StringCollator getStringCollator() {
        try {
            return this.getConfiguration().getCollation(this.getRetainedStaticContext().getDefaultCollationName());
        }
        catch (XPathException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getSingletonOperator() {
        return this.operator;
    }

    @Override
    public boolean convertsUntypedToOther() {
        return false;
    }

    public void setResultWhenEmpty(BooleanValue value) {
        this.resultWhenEmpty = value;
    }

    public BooleanValue getResultWhenEmpty() {
        return this.resultWhenEmpty;
    }

    public boolean needsRuntimeComparabilityCheck() {
        return this.needsRuntimeCheck;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        BuiltInAtomicType p1;
        this.resetLocalStaticProperties();
        this.getLhs().typeCheck(visitor, contextInfo);
        this.getRhs().typeCheck(visitor, contextInfo);
        Configuration config = visitor.getConfiguration();
        if (Literal.isEmptySequence(this.getLhsExpression())) {
            return this.resultWhenEmpty == null ? this.getLhsExpression() : Literal.makeLiteral(this.resultWhenEmpty, this);
        }
        if (Literal.isEmptySequence(this.getRhsExpression())) {
            return this.resultWhenEmpty == null ? this.getRhsExpression() : Literal.makeLiteral(this.resultWhenEmpty, this);
        }
        if (this.convertsUntypedToOther()) {
            return this;
        }
        SequenceType optionalAtomic = SequenceType.OPTIONAL_ATOMIC;
        TypeChecker tc = config.getTypeChecker(false);
        Supplier<RoleDiagnostic> role0 = () -> new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(tc.staticTypeCheck(this.getLhsExpression(), optionalAtomic, role0, visitor));
        Supplier<RoleDiagnostic> role1 = () -> new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(tc.staticTypeCheck(this.getRhsExpression(), optionalAtomic, role1, visitor));
        PlainType t0 = this.getLhsExpression().getItemType().getAtomizedItemType();
        PlainType t1 = this.getRhsExpression().getItemType().getAtomizedItemType();
        if (t0.getUType().union(t1.getUType()).overlaps(UType.EXTENSION)) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocation(this.getLocation());
            throw err;
        }
        BuiltInAtomicType p0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        if (p0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p0 = BuiltInAtomicType.STRING;
        }
        if ((p1 = (BuiltInAtomicType)t1.getPrimitiveItemType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p1 = BuiltInAtomicType.STRING;
        }
        boolean bl = this.needsRuntimeCheck = p0.equals(BuiltInAtomicType.ANY_ATOMIC) || p1.equals(BuiltInAtomicType.ANY_ATOMIC);
        if (!this.needsRuntimeCheck && !Type.isPossiblyComparable(p0, p1, Token.isOrderedOperator(this.operator))) {
            boolean opt0 = Cardinality.allowsZero(this.getLhsExpression().getCardinality());
            boolean opt1 = Cardinality.allowsZero(this.getRhsExpression().getCardinality());
            if (opt0 || opt1) {
                String which = null;
                if (opt0) {
                    which = "the first operand is";
                }
                if (opt1) {
                    which = "the second operand is";
                }
                if (opt0 && opt1) {
                    which = "one or both operands are";
                }
                visitor.getStaticContext().issueWarning("Comparison of " + t0 + (opt0 ? "?" : "") + " to " + t1 + (opt1 ? "?" : "") + " will fail unless " + which + " empty", "SXWN9026", this.getLocation());
                this.needsRuntimeCheck = true;
            } else {
                String message = "In {" + this.toShortString() + "}: cannot compare " + t0 + " to " + t1;
                XPathException err = new XPathException(message);
                err.setIsTypeError(true);
                err.setErrorCode("XPTY0004");
                err.setLocation(this.getLocation());
                throw err;
            }
        }
        if (this.operator != 50 && this.operator != 51) {
            this.mustBeOrdered(t0, p0);
            this.mustBeOrdered(t1, p1);
        }
        return this;
    }

    private void mustBeOrdered(PlainType t1, BuiltInAtomicType p1) throws XPathException {
        if (!p1.isOrdered(true)) {
            XPathException err = new XPathException("Type " + t1.toString() + " is not an ordered type");
            err.setErrorCode("XPTY0004");
            err.setIsTypeError(true);
            err.setLocation(this.getLocation());
            throw err;
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getLhs().optimize(visitor, contextInfo);
        this.getRhs().optimize(visitor, contextInfo);
        return visitor.obtainOptimizer().optimizeValueComparison(this, visitor, contextInfo);
    }

    @Override
    public boolean isNegatable(TypeHierarchy th) {
        return this.isNeverNaN(this.getLhsExpression(), th) && this.isNeverNaN(this.getRhsExpression(), th);
    }

    private boolean isNeverNaN(Expression exp, TypeHierarchy th) {
        return th.relationship(exp.getItemType(), BuiltInAtomicType.DOUBLE) == Affinity.DISJOINT && th.relationship(exp.getItemType(), BuiltInAtomicType.FLOAT) == Affinity.DISJOINT;
    }

    @Override
    public Expression negate() {
        ValueComparison vc = new ValueComparison(this.getLhsExpression(), Token.negate(this.operator), this.getRhsExpression());
        vc.resultWhenEmpty = this.resultWhenEmpty == null || this.resultWhenEmpty == BooleanValue.FALSE ? BooleanValue.TRUE : BooleanValue.FALSE;
        vc.needsRuntimeCheck = this.needsRuntimeCheck;
        ExpressionTool.copyLocationInfo(this, vc);
        return vc;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueComparison && super.equals(other);
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ValueComparison vc = new ValueComparison(this.getLhsExpression().copy(rebindings), this.operator, this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, vc);
        vc.resultWhenEmpty = this.resultWhenEmpty;
        vc.needsRuntimeCheck = this.needsRuntimeCheck;
        return vc;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForBoolean().eval(context);
    }

    public static boolean compare(AtomicValue v0, int op, AtomicValue v1, AtomicComparer comparer, boolean checkTypes) throws XPathException {
        if (checkTypes && !Type.isGuaranteedComparable(v0.getPrimitiveType(), v1.getPrimitiveType(), Token.isOrderedOperator(op))) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
        if (v0.isNaN() || v1.isNaN()) {
            return op == 51;
        }
        try {
            switch (op) {
                case 50: {
                    return comparer.comparesEqual(v0, v1);
                }
                case 51: {
                    return !comparer.comparesEqual(v0, v1);
                }
                case 52: {
                    return comparer.compareAtomicValues(v0, v1) > 0;
                }
                case 53: {
                    return comparer.compareAtomicValues(v0, v1) < 0;
                }
                case 54: {
                    return comparer.compareAtomicValues(v0, v1) >= 0;
                }
                case 55: {
                    return comparer.compareAtomicValues(v0, v1) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + op);
        }
        catch (ComparisonException err) {
            throw err.getReason();
        }
        catch (ClassCastException err) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
    }

    @Override
    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return (BooleanValue)this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return UType.BOOLEAN;
    }

    @Override
    protected int computeCardinality() {
        if (this.resultWhenEmpty != null) {
            return 16384;
        }
        return super.computeCardinality();
    }

    @Override
    protected String tag() {
        return "vc";
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter out) {
        if (this.resultWhenEmpty != null) {
            out.emitAttribute("onEmpty", this.resultWhenEmpty.getBooleanValue() ? "1" : "0");
        }
        if ("JS".equals(out.getOptions().target) && out.getOptions().targetVersion == 2) {
            AtomicComparer comparer = this.getAtomicComparer();
            out.emitAttribute("comp", comparer.save());
        }
    }

    @Override
    public Elaborator getElaborator() {
        return new ValueComparisonElaborator();
    }

    public static class ValueComparisonElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            StringCollator defaultCollation;
            ValueComparison expr = (ValueComparison)this.getExpression();
            ItemEvaluator p0 = expr.getLhsExpression().makeElaborator().elaborateForItem();
            ItemEvaluator p1 = expr.getRhsExpression().makeElaborator().elaborateForItem();
            BooleanValue resultWhenEmpty = expr.getResultWhenEmpty();
            try {
                defaultCollation = expr.getConfiguration().getCollation(expr.getRetainedStaticContext().getDefaultCollationName());
            }
            catch (XPathException e) {
                throw new IllegalStateException("Unknown default collation in static context: " + expr.getRetainedStaticContext().getDefaultCollationName());
            }
            int operator = expr.getOperator();
            int card0 = expr.getLhsExpression().getCardinality();
            int card1 = expr.getRhsExpression().getCardinality();
            if (card0 == 8192 || card1 == 8192) {
                return context -> resultWhenEmpty;
            }
            GenericAtomicComparer.AtomicComparisonFunction comparer = GenericAtomicComparer.makeAtomicComparisonFunction(this.operandType(expr.getLhsExpression()), this.operandType(expr.getRhsExpression()), defaultCollation, operator, true);
            boolean nullable0 = Cardinality.allowsZero(card0);
            boolean nullable1 = Cardinality.allowsZero(card1);
            if (!nullable0 && !nullable1) {
                return context -> BooleanValue.get(comparer.compare((AtomicValue)p0.eval(context), (AtomicValue)p1.eval(context), context));
            }
            return context -> {
                AtomicValue v0 = (AtomicValue)p0.eval(context);
                if (v0 == null) {
                    return resultWhenEmpty;
                }
                AtomicValue v1 = (AtomicValue)p1.eval(context);
                if (v1 == null) {
                    return resultWhenEmpty;
                }
                return BooleanValue.get(comparer.compare(v0, v1, context));
            };
        }

        private BuiltInAtomicType operandType(Expression operand) {
            ItemType type = operand.getItemType();
            if (type == AnyItemType.getInstance()) {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
            return (BuiltInAtomicType)type.getPrimitiveItemType();
        }

        @Override
        public BooleanEvaluator elaborateForBoolean() {
            ItemType t1;
            StringCollator defaultCollation;
            ValueComparison expr = (ValueComparison)this.getExpression();
            ItemEvaluator p0 = expr.getLhsExpression().makeElaborator().elaborateForItem();
            ItemEvaluator p1 = expr.getRhsExpression().makeElaborator().elaborateForItem();
            try {
                defaultCollation = expr.getConfiguration().getCollation(expr.getRetainedStaticContext().getDefaultCollationName());
            }
            catch (XPathException e) {
                throw new IllegalStateException("Unknown default collation in static context: " + expr.getRetainedStaticContext().getDefaultCollationName());
            }
            int operator = expr.getOperator();
            boolean resultWhenEmpty = expr.getResultWhenEmpty() != null && expr.getResultWhenEmpty().getBooleanValue();
            int card0 = expr.getLhsExpression().getCardinality();
            int card1 = expr.getRhsExpression().getCardinality();
            if (card0 == 8192 || card1 == 8192) {
                return context -> resultWhenEmpty;
            }
            ItemType t0 = expr.getLhsExpression().getItemType().getPrimitiveItemType();
            if (!(t0 instanceof BuiltInAtomicType)) {
                t0 = BuiltInAtomicType.ANY_ATOMIC;
            }
            if (!((t1 = expr.getRhsExpression().getItemType().getPrimitiveItemType()) instanceof BuiltInAtomicType)) {
                t1 = BuiltInAtomicType.ANY_ATOMIC;
            }
            GenericAtomicComparer.AtomicComparisonFunction comparer = GenericAtomicComparer.makeAtomicComparisonFunction((BuiltInAtomicType)t0, (BuiltInAtomicType)t1, defaultCollation, operator, true);
            boolean nullable0 = Cardinality.allowsZero(card0);
            boolean nullable1 = Cardinality.allowsZero(card1);
            if (!nullable0 && !nullable1) {
                return context -> comparer.compare((AtomicValue)p0.eval(context), (AtomicValue)p1.eval(context), context);
            }
            return context -> {
                AtomicValue v0 = (AtomicValue)p0.eval(context);
                if (v0 == null) {
                    return resultWhenEmpty;
                }
                AtomicValue v1 = (AtomicValue)p1.eval(context);
                if (v1 == null) {
                    return resultWhenEmpty;
                }
                return comparer.compare(v0, v1, context);
            };
        }
    }
}

