/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.ConstantFunction;
import net.sf.saxon.functions.ContextAccessorFunction;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public abstract class PositionAndLast
extends ContextAccessorFunction {
    private boolean contextPossiblyUndefined = true;

    @Override
    public int getNetCost() {
        return 0;
    }

    @Override
    public FunctionItem bindContext(XPathContext context) {
        Int64Value value;
        try {
            value = this.evaluateItem(context);
        }
        catch (XPathException e) {
            SymbolicName.F name = new SymbolicName.F(this.getFunctionName(), this.getArity());
            CallableDelegate callable = new CallableDelegate((context1, arguments) -> {
                throw e;
            });
            return new CallableFunction(name, (Callable)callable, this.getFunctionItemType());
        }
        ConstantFunction fn = new ConstantFunction(value);
        fn.setDetails(this.getDetails());
        fn.setRetainedStaticContext(this.getRetainedStaticContext());
        return fn;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.PLUS_ONE, Expression.MAX_SEQUENCE_LENGTH};
    }

    @Override
    public void supplyTypeInformation(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression[] arguments) throws XPathException {
        super.supplyTypeInformation(visitor, contextInfo, arguments);
        if (contextInfo.getItemType() == ErrorType.getInstance()) {
            XPathException err = new XPathException("The context item is absent at this point");
            err.setErrorCode("XPDY0002");
            throw err;
        }
        this.contextPossiblyUndefined = contextInfo.isPossiblyAbsent();
    }

    public boolean isContextPossiblyUndefined() {
        return this.contextPossiblyUndefined;
    }

    public abstract Int64Value evaluateItem(XPathContext var1) throws XPathException;

    @Override
    public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evaluateItem(context);
    }

    public static class Last
    extends PositionAndLast {
        @Override
        public Int64Value evaluateItem(XPathContext c) throws XPathException {
            try {
                return Int64Value.makeIntegerValue(c.getLast());
            }
            catch (UncheckedXPathException e) {
                throw XPathException.makeXPathException(e);
            }
        }

        @Override
        public String getStreamerName() {
            return "Last";
        }

        @Override
        public Elaborator getElaborator() {
            return new LastFnElaborator();
        }

        public static class LastFnElaborator
        extends ItemElaborator {
            @Override
            public ItemEvaluator elaborateForItem() {
                SystemFunctionCall sfc = (SystemFunctionCall)this.getExpression();
                Last fn = (Last)sfc.getTargetFunction();
                if (fn.isContextPossiblyUndefined()) {
                    return context -> {
                        FocusIterator focus = context.getCurrentIterator();
                        if (focus == null) {
                            XPathException e = new XPathException("The context item is absent, so last() is undefined");
                            e.setXPathContext(context);
                            e.setLocation(sfc.getLocation());
                            e.setErrorCode("XPDY0002");
                            throw e;
                        }
                        return Int64Value.makeIntegerValue(context.getLast());
                    };
                }
                return context -> Int64Value.makeIntegerValue(context.getLast());
            }
        }
    }

    public static class Position
    extends PositionAndLast {
        @Override
        public Int64Value evaluateItem(XPathContext c) throws XPathException {
            FocusIterator currentIterator = c.getCurrentIterator();
            if (currentIterator == null) {
                XPathException e = new XPathException("The context item is absent, so position() is undefined");
                e.setXPathContext(c);
                e.setErrorCode("XPDY0002");
                throw e;
            }
            return Int64Value.makeIntegerValue(currentIterator.position());
        }

        @Override
        public Elaborator getElaborator() {
            return new PositionFnElaborator();
        }

        public static class PositionFnElaborator
        extends ItemElaborator {
            @Override
            public ItemEvaluator elaborateForItem() {
                SystemFunctionCall sfc = (SystemFunctionCall)this.getExpression();
                Position fn = (Position)sfc.getTargetFunction();
                if (fn.isContextPossiblyUndefined()) {
                    return context -> {
                        FocusIterator focus = context.getCurrentIterator();
                        if (focus == null) {
                            XPathException e = new XPathException("The context item is absent, so position() is undefined");
                            e.setXPathContext(context);
                            e.setLocation(sfc.getLocation());
                            e.setErrorCode("XPDY0002");
                            throw e;
                        }
                        return Int64Value.makeIntegerValue(focus.position());
                    };
                }
                return context -> Int64Value.makeIntegerValue(context.getCurrentIterator().position());
            }
        }
    }
}

