/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.Whitespace;

public class NamespaceUri {
    private static final ConcurrentHashMap<String, NamespaceUri> stringToNamespaceUri = new ConcurrentHashMap(20);
    private final String stringContent;
    private final UnicodeString unicodeStringContent;
    public static final NamespaceUri NULL = NamespaceUri.of("");
    public static final NamespaceUri XML = NamespaceUri.of("http://www.w3.org/XML/1998/namespace");
    public static final NamespaceUri XSLT = NamespaceUri.of("http://www.w3.org/1999/XSL/Transform");
    public static final NamespaceUri SAXON = NamespaceUri.of("http://saxon.sf.net/");
    public static final NamespaceUri SAXON6 = NamespaceUri.of("http://icl.com/saxon");
    public static final NamespaceUri SAXON_XSLT_EXPORT = NamespaceUri.of("http://ns.saxonica.com/xslt/export");
    public static final NamespaceUri SCHEMA = NamespaceUri.of("http://www.w3.org/2001/XMLSchema");
    public static final NamespaceUri SCHEMA_INSTANCE = NamespaceUri.of("http://www.w3.org/2001/XMLSchema-instance");
    public static final NamespaceUri SCHEMA_VERSIONING = NamespaceUri.of("http://www.w3.org/2007/XMLSchema-versioning");
    public static final NamespaceUri SQL = NamespaceUri.of("http://saxon.sf.net/sql");
    public static final NamespaceUri EXSLT_COMMON = NamespaceUri.of("http://exslt.org/common");
    public static final NamespaceUri EXSLT_MATH = NamespaceUri.of("http://exslt.org/math");
    public static final NamespaceUri EXSLT_SETS = NamespaceUri.of("http://exslt.org/sets");
    public static final NamespaceUri EXSLT_DATES_AND_TIMES = NamespaceUri.of("http://exslt.org/dates-and-times");
    public static final NamespaceUri EXSLT_RANDOM = NamespaceUri.of("http://exslt.org/random");
    public static final NamespaceUri FN = NamespaceUri.of("http://www.w3.org/2005/xpath-functions");
    public static final NamespaceUri OUTPUT = NamespaceUri.of("http://www.w3.org/2010/xslt-xquery-serialization");
    public static final NamespaceUri ERR = NamespaceUri.of("http://www.w3.org/2005/xqt-errors");
    public static final NamespaceUri LOCAL = NamespaceUri.of("http://www.w3.org/2005/xquery-local-functions");
    public static final NamespaceUri MATH = NamespaceUri.of("http://www.w3.org/2005/xpath-functions/math");
    public static final NamespaceUri MAP_FUNCTIONS = NamespaceUri.of("http://www.w3.org/2005/xpath-functions/map");
    public static final NamespaceUri ARRAY_FUNCTIONS = NamespaceUri.of("http://www.w3.org/2005/xpath-functions/array");
    public static final NamespaceUri EXPATH_BINARY = NamespaceUri.of("http://expath.org/ns/binary");
    public static final NamespaceUri EXPATH_FILE = NamespaceUri.of("http://expath.org/ns/file");
    public static final NamespaceUri XHTML = NamespaceUri.of("http://www.w3.org/1999/xhtml");
    public static final NamespaceUri SVG = NamespaceUri.of("http://www.w3.org/2000/svg");
    public static final NamespaceUri MATHML = NamespaceUri.of("http://www.w3.org/1998/Math/MathML");
    public static final NamespaceUri XMLNS = NamespaceUri.of("http://www.w3.org/2000/xmlns/");
    public static final NamespaceUri XLINK = NamespaceUri.of("http://www.w3.org/1999/xlink");
    public static final NamespaceUri XQUERY = NamespaceUri.of("http://www.w3.org/2012/xquery");
    public static final NamespaceUri JAVA_TYPE = NamespaceUri.of("http://saxon.sf.net/java-type");
    public static final NamespaceUri DOT_NET_TYPE = NamespaceUri.of("http://saxon.sf.net/clitype");
    public static final NamespaceUri ANONYMOUS = NamespaceUri.of("http://ns.saxonica.com/anonymous-type");
    public static final NamespaceUri SCM = NamespaceUri.of("http://ns.saxonica.com/schema-component-model");
    public static final NamespaceUri OBJECT_MODEL_SAXON = NamespaceUri.of("http://saxon.sf.net/jaxp/xpath/om");
    public static final NamespaceUri OBJECT_MODEL_XOM = NamespaceUri.of("http://www.xom.nu/jaxp/xpath/xom");
    public static final NamespaceUri OBJECT_MODEL_JDOM = NamespaceUri.of("http://jdom.org/jaxp/xpath/jdom");
    public static final NamespaceUri OBJECT_MODEL_AXIOM = NamespaceUri.of("http://ws.apache.org/jaxp/xpath/axiom");
    public static final NamespaceUri OBJECT_MODEL_DOM4J = NamespaceUri.of("http://www.dom4j.org/jaxp/xpath/dom4j");
    public static final NamespaceUri OBJECT_MODEL_DOT_NET_DOM = NamespaceUri.of("http://saxon.sf.net/object-model/dotnet/dom");
    public static final NamespaceUri OBJECT_MODEL_DOMINO = NamespaceUri.of("http://saxon.sf.net/object-model/domino");
    public static final NamespaceUri SAXON_GENERATED_VARIABLE = NamespaceUri.of("http://saxon.sf.net/generated-variable");
    public static final NamespaceUri SAXON_CONFIGURATION = NamespaceUri.of("http://saxon.sf.net/ns/configuration");
    public static final NamespaceUri EXPATH_ZIP = NamespaceUri.of("http://expath.org/ns/zip");
    public static final NamespaceUri GLOBAL_JS = NamespaceUri.of("http://saxonica.com/ns/globalJS");
    public static final NamespaceUri PHP = NamespaceUri.of("http://php.net/xsl");
    public static final NamespaceUri IXSL = NamespaceUri.of("http://saxonica.com/ns/interactiveXSLT");

    public static NamespaceUri of(String content) {
        if (content == null) {
            content = "";
        }
        return stringToNamespaceUri.computeIfAbsent(Whitespace.trim(content), NamespaceUri::new);
    }

    private NamespaceUri(String content) {
        this.stringContent = content;
        this.unicodeStringContent = StringTool.fromCharSequence(content);
    }

    public String toString() {
        return this.stringContent;
    }

    public UnicodeString toUnicodeString() {
        return this.unicodeStringContent;
    }

    public boolean isEmpty() {
        return this == NULL;
    }

    public static NamespaceUri getUriForConventionalPrefix(String prefix) {
        switch (prefix) {
            case "xsl": {
                return XSLT;
            }
            case "fn": {
                return FN;
            }
            case "xml": {
                return XML;
            }
            case "xs": {
                return SCHEMA;
            }
            case "xsi": {
                return SCHEMA_INSTANCE;
            }
            case "err": {
                return ERR;
            }
            case "ixsl": {
                return IXSL;
            }
            case "js": {
                return GLOBAL_JS;
            }
            case "saxon": {
                return SAXON;
            }
            case "vv": {
                return SAXON_GENERATED_VARIABLE;
            }
            case "math": {
                return MATH;
            }
            case "map": {
                return MAP_FUNCTIONS;
            }
            case "array": {
                return ARRAY_FUNCTIONS;
            }
        }
        return null;
    }

    public static boolean isReserved(NamespaceUri uri) {
        return uri != null && (uri.equals(XSLT) || uri.equals(FN) || uri.equals(MATH) || uri.equals(MAP_FUNCTIONS) || uri.equals(ARRAY_FUNCTIONS) || uri.equals(XML) || uri.equals(SCHEMA) || uri.equals(SCHEMA_INSTANCE) || uri.equals(ERR) || uri.equals(XMLNS));
    }

    public static boolean isReservedInQuery31(NamespaceUri uri) {
        return uri.equals(FN) || uri.equals(XML) || uri.equals(SCHEMA) || uri.equals(SCHEMA_INSTANCE) || uri.equals(MATH) || uri.equals(XQUERY) || uri.equals(MAP_FUNCTIONS) || uri.equals(ARRAY_FUNCTIONS);
    }
}

