/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class XSLItemType
extends StyleElement {
    private StructuredQName itemTypeName;
    private boolean resolved = false;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    protected void prepareAttributes() {
        if (this.itemTypeName != null) {
            return;
        }
        String typeAtt = null;
        block10: for (AttributeInfo att : this.attributes()) {
            String f;
            NodeName attName = att.getNodeName();
            String value = att.getValue();
            switch (f = attName.getDisplayName()) {
                case "name": {
                    this.itemTypeName = this.makeQName(value, null, "name");
                    continue block10;
                }
                case "as": {
                    typeAtt = value;
                    continue block10;
                }
                case "visibility": {
                    if (value.equals("private")) continue block10;
                    this.compileErrorInAttribute("Not implemented", "XTSE0010", "visibility");
                    continue block10;
                }
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.itemTypeName == null) {
            this.reportAbsence("name");
        }
        if (typeAtt == null) {
            this.reportAbsence("as");
        }
    }

    @Override
    public StructuredQName getObjectName() {
        if (this.itemTypeName == null) {
            this.prepareAttributes();
        }
        return this.itemTypeName;
    }

    public void indexTypeAlias(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        this.prepareAttributes();
        top.getTypeAliasManager().processDeclaration(decl);
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
        this.getConfiguration().checkLicensedFeature(8, "saxon:item-type", this.getPackageData().getLocalLicenseId());
    }

    public ItemType tryToResolve() throws XPathException {
        TypeAliasContext env = new TypeAliasContext(this);
        this.resolved = true;
        ItemType type = this.makeItemType(env);
        return this.resolved ? type : null;
    }

    private void markUnresolved() {
        this.resolved = false;
    }

    private ItemType makeItemType(StaticContext env) throws XPathException {
        try {
            SequenceType st;
            XPathParser parser = this.getConfiguration().newExpressionParser("XP", false);
            QNameParser qp = new QNameParser(env.getNamespaceResolver()).withAcceptEQName(true).withErrorOnBadSyntax("XPST0003").withErrorOnUnresolvedPrefix("XPST0081");
            parser.setQNameParser(qp);
            String typeAtt = this.getAttributeValue("as");
            if (typeAtt == null) {
                this.reportAbsence("as");
                typeAtt = "item()";
            }
            if ((st = parser.parseExtendedSequenceType(typeAtt, env)).getCardinality() != 16384) {
                this.compileError("Item type must not include an occurrence indicator");
            }
            return st.getPrimaryType();
        }
        catch (XPathException err) {
            this.compileError(err);
            return AnyItemType.getInstance();
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return null;
    }

    private static class TypeAliasContext
    extends ExpressionContext {
        public TypeAliasContext(XSLItemType declaration) {
            super(declaration, new StructuredQName("", NamespaceUri.NULL, "as"));
        }

        @Override
        public ItemType resolveTypeAlias(StructuredQName typeName) {
            ItemType resolved = super.resolveTypeAlias(typeName);
            if (resolved == null) {
                ((XSLItemType)this.getStyleElement()).markUnresolved();
                return AnyItemType.getInstance();
            }
            return resolved;
        }
    }
}

