/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.Type;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.NestedProperty;
import org.directwebremoting.extend.Property;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterProperty
implements Property {
    private final MethodDeclaration method;
    private final int parameterNumber;

    public ParameterProperty(MethodDeclaration method, int parameterNumber) {
        this.method = method;
        this.parameterNumber = parameterNumber;
    }

    @Override
    public String getName() {
        return "parameter" + this.parameterNumber;
    }

    @Override
    public Class<?> getPropertyType() {
        Type[] types = this.method.getGenericParameterTypes();
        if (this.parameterNumber >= types.length) {
            throw new IllegalArgumentException("parameterNumber=" + this.parameterNumber + " is too big when method=" + this.method.getName() + " returns genericParameterTypes.length=" + types.length);
        }
        Type parameterType = types[this.parameterNumber];
        return LocalUtil.toClass(parameterType, this.toString());
    }

    @Override
    public Object getValue(Object bean) throws ConversionException {
        throw new UnsupportedOperationException("Can't get value from method parameter");
    }

    @Override
    public void setValue(Object bean, Object value) throws ConversionException {
        throw new UnsupportedOperationException("Can't set value to method parameter");
    }

    @Override
    public Property createChild(int aNewParameterNumber) {
        Type[] types = this.method.getGenericParameterTypes();
        if (this.parameterNumber >= types.length) {
            throw new IllegalArgumentException("parameterNumber=" + this.parameterNumber + " is too big when method=" + this.method.getName() + " returns genericParameterTypes.length=" + types.length);
        }
        Type parameterType = types[this.parameterNumber];
        return new NestedProperty(this, this.method, parameterType, this.parameterNumber, aNewParameterNumber);
    }

    public int hashCode() {
        return this.method.hashCode() + this.parameterNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterProperty that = (ParameterProperty)obj;
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.parameterNumber == that.parameterNumber;
    }

    public String toString() {
        return "ParameterProperty[method=" + this.method.getName() + ",p#=" + this.parameterNumber + "]";
    }
}

