/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice.util;

import com.google.inject.Provider;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.directwebremoting.guice.util.InstanceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FutureTaskProvider<T>
extends FutureTask<T>
implements InstanceProvider<T> {
    FutureTaskProvider(final Provider<T> creator) {
        super(new Callable<T>(){

            @Override
            public T call() {
                return creator.get();
            }
        });
    }

    @Override
    public T get() {
        try {
            return (T)super.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalStateException("unexpected Exception: " + t, t);
        }
    }
}

