/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.ScriptSessionFilter;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.TaskDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskDispatcher
implements TaskDispatcher {
    private ScriptSessionManager scriptSessionManager;
    private final ThreadLocal<Collection<ScriptSession>> target = new ThreadLocal();
    private static final Log log = LogFactory.getLog(DefaultTaskDispatcher.class);

    @Override
    public void dispatchTask(ScriptSessionFilter filter, Runnable task) {
        Collection<ScriptSession> all = this.scriptSessionManager.getAllScriptSessions();
        ArrayList<ScriptSession> use = new ArrayList<ScriptSession>();
        for (ScriptSession session : all) {
            if (!filter.match(session)) continue;
            use.add(session);
        }
        if (use.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Execution time: " + new Date().toString() + " - Executing task (" + task.getClass().getSimpleName() + ") against " + use.size() + " sessions."));
            }
            this.target.set(use);
            task.run();
            this.target.remove();
        }
    }

    @Override
    public Collection<ScriptSession> getTargetSessions() {
        return this.target.get();
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }
}

