/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import org.directwebremoting.util.Loggers;
import org.dojotoolkit.shrinksafe.Compressor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.Main;

public class ShrinkSafeCompressor
implements org.directwebremoting.extend.Compressor {
    protected Global global;
    protected Method compressReaderMethod;

    public ShrinkSafeCompressor() throws Exception {
        try {
            this.global = Main.getGlobal();
            ToolErrorReporter errorReporter = new ToolErrorReporter(false, this.global.getErr());
            Main.shellContextFactory.setErrorReporter((ErrorReporter)errorReporter);
            this.compressJavaScript("");
        }
        catch (NoClassDefFoundError ex) {
            throw new InstantiationException("Could not setup ShrinkSafeCompressor because a class is missing, assuming shrinksafe.jar and js.jar are not in the classpath.");
        }
        catch (Exception ex) {
            Loggers.STARTUP.error((Object)"ShrinkSafeCompressor startup", (Throwable)ex);
            throw new InstantiationException("Could not setup ShrinkSafeCompressor, assuming shrinksafe.jar and js.jar are not in the classpath. Exception caught was " + ex);
        }
    }

    public String compressJavaScript(final String source) throws Exception {
        final Exception[] thrown = new Exception[1];
        String reply = (String)Main.shellContextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                try {
                    String obfuscated = Compressor.compressScript((String)source, (int)0, (int)1, (boolean)false, null);
                    return obfuscated.replaceAll("[\\r\\n]", "");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    thrown[0] = ex;
                    return null;
                }
            }
        });
        if (thrown[0] != null) {
            throw thrown[0];
        }
        return reply;
    }
}

