/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json.parse.javacc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.directwebremoting.json.parse.JsonDecoder;
import org.directwebremoting.json.parse.JsonParseException;
import org.directwebremoting.json.parse.JsonParser;
import org.directwebremoting.json.parse.javacc.JavaccJsonParserConstants;
import org.directwebremoting.json.parse.javacc.JavaccJsonParserTokenManager;
import org.directwebremoting.json.parse.javacc.ParseException;
import org.directwebremoting.json.parse.javacc.SimpleCharStream;
import org.directwebremoting.json.parse.javacc.Token;
import org.directwebremoting.json.parse.javacc.TokenMgrError;

public class JavaccJsonParser
implements JsonParser,
JavaccJsonParserConstants {
    public JavaccJsonParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[13];
    private static int[] jj_la1_0;
    private final Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public JavaccJsonParser() {
        this(new StringReader(""));
    }

    public Object parse(Reader reader, JsonDecoder decoder) throws JsonParseException {
        this.ReInit(reader);
        try {
            this.top(decoder);
        }
        catch (TokenMgrError ex) {
            throw new JsonParseException(ex.getMessage());
        }
        return decoder.getRoot();
    }

    public final void top(JsonDecoder decoder) throws ParseException, JsonParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.object(decoder, null);
                break;
            }
            case 16: {
                this.array(decoder, null);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void object(JsonDecoder decoder, String propertyName) throws ParseException, JsonParseException {
        decoder.beginObject(propertyName);
        this.jj_consume_token(12);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.pair(decoder);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 13: {
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(13);
                    this.pair(decoder);
                }
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(14);
        decoder.endObject(propertyName);
    }

    public final void pair(JsonDecoder decoder) throws ParseException, JsonParseException {
        String propertyName = this.propertyName();
        this.jj_consume_token(15);
        this.value(decoder, propertyName);
    }

    public final void array(JsonDecoder decoder, String propertyName) throws ParseException, JsonParseException {
        decoder.beginArray(propertyName);
        this.jj_consume_token(16);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 4: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.value(decoder, null);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 13: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(13);
                    this.value(decoder, null);
                }
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(17);
        decoder.endArray(propertyName);
    }

    public final void value(JsonDecoder decoder, String propertyName) throws ParseException, JsonParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.string(decoder, propertyName);
                break;
            }
            case 3: 
            case 21: {
                this.number(decoder, propertyName);
                break;
            }
            case 12: {
                this.object(decoder, propertyName);
                break;
            }
            case 16: {
                this.array(decoder, propertyName);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                this.literal(decoder, propertyName);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void literal(JsonDecoder decoder, String propertyName) throws ParseException, JsonParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                decoder.addBoolean(propertyName, true);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                decoder.addBoolean(propertyName, false);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                decoder.addNull(propertyName);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void number(JsonDecoder decoder, String propertyName) throws ParseException, JsonParseException {
        String intPart = null;
        String floatPart = null;
        String expPart = null;
        intPart = this.getIntPart();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                floatPart = this.getFloatPart();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                expPart = this.getExpPart();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        decoder.addNumber(propertyName, intPart, floatPart, expPart);
        intPart = null;
        floatPart = null;
        expPart = null;
    }

    public final String getIntPart() throws ParseException, JsonParseException {
        boolean negative = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                negative = true;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        String digits = this.getDigits();
        if (negative) {
            return "-" + digits;
        }
        return digits;
    }

    public final String getFloatPart() throws ParseException, JsonParseException {
        this.jj_consume_token(22);
        String digits = this.getDigits();
        return "." + digits;
    }

    public final String getExpPart() throws ParseException, JsonParseException {
        Token t = this.jj_consume_token(2);
        String digits = this.getDigits();
        return t.image + digits;
    }

    public final String getDigits() throws ParseException, JsonParseException {
        Token t = this.jj_consume_token(3);
        return t.image;
    }

    public final String propertyName() throws ParseException, JsonParseException {
        StringBuilder builder = new StringBuilder();
        this.jj_consume_token(4);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.getChar(builder);
        }
        this.jj_consume_token(6);
        return builder.toString();
    }

    public final void string(JsonDecoder decoder, String propertyName) throws ParseException, JsonParseException {
        StringBuilder builder = new StringBuilder();
        this.jj_consume_token(4);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.getChar(builder);
        }
        this.jj_consume_token(6);
        decoder.addString(propertyName, builder.toString());
    }

    public final void getChar(StringBuilder builder) throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                t = this.jj_consume_token(7);
                break;
            }
            case 8: {
                t = this.jj_consume_token(8);
                break;
            }
            case 11: {
                t = this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (t.image.length() < 2) {
            builder.append(t.image.charAt(0));
        } else if (t.image.length() < 6) {
            char c = t.image.charAt(1);
            switch (c) {
                case 'b': {
                    builder.append('\b');
                    break;
                }
                case 'f': {
                    builder.append('\f');
                    break;
                }
                case 'n': {
                    builder.append('\n');
                    break;
                }
                case 'r': {
                    builder.append('\r');
                    break;
                }
                case 't': {
                    builder.append('\t');
                    break;
                }
                default: {
                    builder.append(c);
                    break;
                }
            }
        } else {
            int i = Integer.valueOf(t.image.substring(2, 6), 16);
            builder.append((char)i);
        }
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{69632, 8192, 16, 8192, 4001816, 4001816, 0x1C0000, 0x400000, 4, 0x200000, 2432, 2432, 2432};
    }

    public JavaccJsonParser(InputStream stream) {
        this(stream, null);
    }

    public JavaccJsonParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JavaccJsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JavaccJsonParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JavaccJsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JavaccJsonParser(JavaccJsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(JavaccJsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[23];
        for (i = 0; i < 23; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 13; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 23; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        JavaccJsonParser.jj_la1_0();
    }
}

