/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.servlet3;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Sleeper;

public class Servlet3Sleeper
implements Sleeper {
    private static final Method suspendMethod;
    private static final Method completeMethod;
    private HttpServletRequest request;
    private final Object wakeUpCalledLock = new Object();
    private boolean wakeUpCalled = false;
    protected boolean resumed = false;
    private static final Log log;

    public Servlet3Sleeper(HttpServletRequest request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleep(Runnable onAwakening) {
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                onAwakening.run();
            } else {
                try {
                    suspendMethod.invoke((Object)this.request, new Object[0]);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                return;
            }
            this.wakeUpCalled = true;
            try {
                completeMethod.invoke((Object)this.request, new Object[0]);
            }
            catch (Exception ex) {
                log.warn((Object)"Error completing comet request", (Throwable)ex);
            }
        }
    }

    static {
        try {
            suspendMethod = HttpServletRequest.class.getMethod("suspend", new Class[0]);
            completeMethod = HttpServletRequest.class.getMethod("complete", new Class[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        log = LogFactory.getLog(Servlet3Sleeper.class);
    }
}

