/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.Scope;
import liquibase.ui.InputHandler;
import liquibase.ui.UIService;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCommandLineValueGetter<T> {
    public static final String NEW_PARAMETER_VALUES_SCOPE_KEY = "newParameterValues";
    private final Class<T> clazz;

    public AbstractCommandLineValueGetter(Class<T> clazz) {
        this.clazz = clazz;
    }

    public final T prompt(RuleParameter<T> parameter, List<DynamicRuleParameter> newParameterValues, Object currentValue) throws Exception {
        Object valueToPromptAsDefault;
        if (currentValue != null) {
            try {
                valueToPromptAsDefault = this.convert((String)currentValue);
            }
            catch (Exception e) {
                valueToPromptAsDefault = currentValue;
            }
        } else {
            AtomicReference valueToPromptAsDefaultRef = new AtomicReference();
            Scope.child((String)NEW_PARAMETER_VALUES_SCOPE_KEY, newParameterValues, () -> valueToPromptAsDefaultRef.set(parameter.getDefaultValue()));
            valueToPromptAsDefault = valueToPromptAsDefaultRef.get();
        }
        Object prompt = null;
        boolean valid = false;
        while (!valid && (prompt == null || prompt.equals(valueToPromptAsDefault))) {
            prompt = this.doPrompt(parameter, newParameterValues, valueToPromptAsDefault, currentValue != null || parameter.getDefaultValue() != null || parameter.allowEmpty());
            try {
                valid = this.doValidate(parameter, newParameterValues, prompt);
            }
            catch (IllegalArgumentException e) {
                UIService uiService = Scope.getCurrentScope().getUI();
                if (uiService.getAllowPrompt()) {
                    uiService.sendErrorMessage("Invalid value: '" + prompt + "': " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return (T)prompt;
    }

    private T doPrompt(final RuleParameter<T> parameter, final List<DynamicRuleParameter> newParameterValues, Object valueToPromptAsDefault, final boolean shouldAllowEmptyValues) {
        return (T)Scope.getCurrentScope().getUI().prompt(this.getMessage(parameter), valueToPromptAsDefault, new InputHandler<T>(){

            public T parseInput(String input, Class<T> type) throws IllegalArgumentException {
                Object convert;
                try {
                    convert = AbstractCommandLineValueGetter.this.convert(input);
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        throw new IllegalArgumentException(String.format("Invalid value: '%s': %s", input, e.getMessage()), e);
                    }
                    throw new IllegalArgumentException(e);
                }
                try {
                    if (!AbstractCommandLineValueGetter.this.doValidate(parameter, newParameterValues, convert)) {
                        throw new IllegalArgumentException("The supplied value is not valid.");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        throw new IllegalArgumentException(String.format("Invalid value: '%s': %s", input, e.getMessage()), e);
                    }
                    throw new IllegalArgumentException(String.format("Invalid value: '%s': The supplied value is not valid.", input), e);
                }
                return convert;
            }

            public boolean shouldAllowEmptyInput() {
                return shouldAllowEmptyValues;
            }
        }, this.clazz);
    }

    private boolean doValidate(RuleParameter<T> parameter, List<DynamicRuleParameter> newParameterValues, T convert) throws IllegalArgumentException {
        if (parameter.getValidationCallbackOverride() != null) {
            return parameter.getValidationCallbackOverride().apply(convert, newParameterValues);
        }
        return this.validate(convert);
    }

    private String getMessage(RuleParameter<?> parameter) {
        String msg = parameter.getParameter().uiMessage;
        if (StringUtils.isNotEmpty((CharSequence)parameter.getOptions())) {
            msg = msg + " (options: " + parameter.getOptions() + ")";
        } else if (StringUtil.isNotEmpty((String)parameter.getParameter().options)) {
            msg = msg + " (options: " + parameter.getParameter().options + ")";
        }
        return msg;
    }

    public abstract boolean validate(T var1);

    public abstract T convert(String var1);

    public String describe() {
        return this.getClass().getSimpleName();
    }
}

