/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.dynamic.AbstractObjectNamingListRule;
import com.datical.liquibase.ext.checks.dynamic.ObjectTypesEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DisallowPostgresNonReservedKeywords
extends AbstractObjectNamingListRule {
    protected static final String POSTGRES_URL = "https://www.postgresql.org/docs/14/sql-keywords-appendix.html";
    private static final Set<String> POSTGRES_NON_RESERVED_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("A", "ABORT", "ABSENT", "ACCESS", "ACCORDING", "ADA", "ADMIN", "AFTER", "AGGREGATE", "ALSO", "ALWAYS", "ASSIGNMENT", "ATTACH", "ATTRIBUTE", "ATTRIBUTES", "BACKWARD", "BASE64", "BEFORE", "BERNOULLI", "BLOCKED", "BOM", "BREADTH", "C", "CACHE", "CATALOG_NAME", "CHAIN", "CHAINING", "CHARACTER_SET_CATALOG", "CHARACTER_SET_NAME", "CHARACTER_SET_SCHEMA", "CHARACTERISTICS", "CHARACTERS", "CHECKPOINT", "CLASS", "CLASS_ORIGIN", "CLUSTER", "COBOL", "COLLATION_CATALOG", "COLLATION_NAME", "COLLATION_SCHEMA", "COLUMN_NAME", "COLUMNS", "COMMAND_FUNCTION", "COMMAND_FUNCTION_CODE", "COMMENT", "COMMENTS", "COMMITTED", "COMPRESSION", "CONDITION_NUMBER", "CONDITIONAL", "CONFIGURATION", "CONFLICT", "CONNECTION_NAME", "CONSTRAINT_CATALOG", "CONSTRAINT_NAME", "CONSTRAINT_SCHEMA", "CONSTRUCTOR", "CONTENT", "CONTROL", "CONVERSION", "COST", "CSV", "CURSOR_NAME", "DATA", "DATABASE", "DATETIME_INTERVAL_CODE", "DATETIME_INTERVAL_PRECISION", "DB", "DEFAULTS", "DEFINED", "DEFINER", "DEGREE", "DELIMITER", "DELIMITERS", "DEPENDS", "DEPTH", "DERIVED", "DETACH", "DICTIONARY", "DISABLE", "DISCARD", "DISPATCH", "DOCUMENT", "DYNAMIC_FUNCTION", "DYNAMIC_FUNCTION_CODE", "ENABLE", "ENCODING", "ENCRYPTED", "ENFORCED", "ENUM", "ERROR", "EVENT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXPLAIN", "EXPRESSION", "EXTENSION", "FAMILY", "FILE", "FINAL", "FINALIZE", "FINISH", "FLAG", "FOLLOWING", "FORCE", "FORMAT", "FORTRAN", "FORWARD", "FS", "FULFILL", "FUNCTIONS", "G", "GENERAL", "GENERATED", "GRANTED", "GREATEST", "HANDLER", "HEADER", "HEX", "HIERARCHY", "ID", "IF", "IGNORE", "IMMEDIATELY", "IMMUTABLE", "IMPLEMENTATION", "IMPLICIT", "INCLUDE", "INCLUDING", "INCREMENT", "INDENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INLINE", "INSTANCE", "INSTANTIABLE", "INSTEAD", "INTEGRITY", "INVOKER", "JSON", "K", "KEEP", "KEY_MEMBER", "KEY_TYPE", "KEYS", "LABEL", "LEAKPROOF", "LEAST", "LENGTH", "LIBRARY", "LINK", "LISTEN", "LOAD", "LOCATION", "LOCATOR", "LOCK", "LOCKED", "LOGGED", "M", "MAP", "MAPPING", "MATCHED", "MATERIALIZED", "MAXVALUE", "MESSAGE_LENGTH", "MESSAGE_OCTET_LENGTH", "MESSAGE_TEXT", "MINVALUE", "MODE", "MORE", "MOVE", "MUMPS", "NAME", "NAMESPACE", "NESTED", "NESTING", "NFC", "NFD", "NFKC", "NFKD", "NIL", "NORMALIZED", "NOTHING", "NOTIFY", "NOWAIT", "NULLABLE", "NULLS", "NUMBER", "OBJECT", "OCTETS", "OFF", "OIDS", "OPERATOR", "OPTIONS", "ORDERING", "ORDINALITY", "OTHERS", "OVERFLOW", "OVERRIDING", "OWNED", "OWNER", "P", "PARALLEL", "PARAMETER_MODE", "PARAMETER_NAME", "PARAMETER_ORDINAL_POSITION", "PARAMETER_SPECIFIC_CATALOG", "PARAMETER_SPECIFIC_NAME", "PARAMETER_SPECIFIC_SCHEMA", "PARSER", "PASCAL", "PASS", "PASSING", "PASSTHROUGH", "PASSWORD", "PAST", "PATH", "PERMISSION", "PLAN", "PLANS", "PLI", "POLICY", "PRECEDING", "PREPARED", "PRIVATE", "PROCEDURAL", "PROCEDURES", "PROGRAM", "PRUNE", "PUBLIC", "PUBLICATION", "QUOTE", "QUOTES", "REASSIGN", "RECHECK", "RECOVERY", "REFRESH", "REINDEX", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", "REQUIRING", "RESET", "RESPECT", "RESTART", "RESTORE", "RETURNED_CARDINALITY", "RETURNED_LENGTH", "RETURNED_OCTET_LENGTH", "RETURNED_SQLSTATE", "ROLE", "ROUTINE", "ROUTINE_CATALOG", "ROUTINE_NAME", "ROUTINE_SCHEMA", "ROUTINES", "ROW_COUNT", "RULE", "SCALAR", "SCALE", "SCHEMA_NAME", "SCHEMAS", "SCOPE_CATALOG", "SCOPE_NAME", "SCOPE_SCHEMA", "SECURITY", "SELECTIVE", "SELF", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", "SERVER_NAME", "SETOF", "SETS", "SHARE", "SIMPLE", "SNAPSHOT", "SOURCE", "SPECIFIC_NAME", "STABLE", "STANDALONE", "STATE", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STORED", "STRICT", "STRING", "STRIP", "STRUCTURE", "STYLE", "SUBCLASS_ORIGIN", "SUBSCRIPTION", "SUPPORT", "SYSID", "T", "TABLE_NAME", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEXT", "THROUGH", "TIES", "TOKEN", "TOP_LEVEL_COUNT", "TRANSACTION_ACTIVE", "TRANSACTIONS_COMMITTED", "TRANSACTIONS_ROLLED_BACK", "TRANSFORM", "TRANSFORMS", "TRIGGER_CATALOG", "TRIGGER_NAME", "TRIGGER_SCHEMA", "TRUSTED", "TYPE", "TYPES", "UNBOUNDED", "UNCOMMITTED", "UNCONDITIONAL", "UNDER", "UNENCRYPTED", "UNLINK", "UNLISTEN", "UNLOGGED", "UNNAMED", "UNTIL", "UNTYPED", "URI", "USER_DEFINED_TYPE_CATALOG", "USER_DEFINED_TYPE_CODE", "USER_DEFINED_TYPE_NAME", "USER_DEFINED_TYPE_SCHEMA", "UTF16", "UTF32", "UTF8", "VACUUM", "VALID", "VALIDATE", "VALIDATOR", "VERSION", "VIEWS", "VOLATILE", "WHITESPACE", "WRAPPER", "XMLDECLARATION", "XMLROOT", "XMLSCHEMA", "YES")));

    @Override
    public String getFailureMessage(ObjectTypesEnum objectType, OperatorEnum operatorEnum, String searchString, String message, String objectName) {
        return "The " + (Object)((Object)objectType) + " named " + objectName + " is a Postgres non-reserved keyword. Please review and change the object name, or add this word to this check's Allowed List.";
    }

    @Override
    public String getDescription() {
        return "Disallow Postgres non-reserved keywords from being used in database object names. See https://www.postgresql.org/docs/14/sql-keywords-appendix.html for complete list of keywords.";
    }

    @Override
    public String getShortName() {
        return "PostgresNonReservedKeywords";
    }

    @Override
    public int getPriority() {
        return 127;
    }

    @Override
    public Set<String> getForbiddenWords() {
        return POSTGRES_NON_RESERVED_KEYWORDS;
    }

    @Override
    public String getAllowedListValidationErrorMessage() {
        return "is not a Postgres non-reserved keyword. See https://www.postgresql.org/docs/14/sql-keywords-appendix.html for complete list of keywords.";
    }
}

