/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.api.Fact;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.RulesEngineParameters;
import com.datical.liquibase.ext.rules.core.AbstractRulesEngine;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import liquibase.Scope;
import liquibase.logging.Logger;

public final class DefaultRulesEngine
extends AbstractRulesEngine {
    public DefaultRulesEngine() {
    }

    public DefaultRulesEngine(RulesEngineParameters parameters) {
        super(parameters);
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    void doFire(Rules rules, Facts facts) {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        if (rules.isEmpty()) {
            LOGGER.warning("No rules registered! Nothing to apply");
            return;
        }
        this.logEngineParameters();
        this.log(rules);
        this.log(facts);
        LOGGER.fine("Rules evaluation started");
        for (Rule rule : rules) {
            boolean evaluationResult;
            String name;
            block9: {
                name = rule.getName();
                int priority = rule.getPriority();
                if (priority > this.parameters.getPriorityThreshold()) {
                    LOGGER.fine("Rule priority threshold (" + this.parameters.getPriorityThreshold() + ") exceeded at rule '" + name + "' with priority=" + priority + ", next rule will be skipped");
                    break;
                }
                if (!this.shouldBeEvaluated(rule, facts)) {
                    LOGGER.fine("Rule '" + name + "' has been skipped before being evaluated");
                    continue;
                }
                evaluationResult = false;
                try {
                    evaluationResult = rule.evaluate(facts);
                }
                catch (RuntimeException exception) {
                    LOGGER.severe("Rule '" + name + "' evaluated with error", (Throwable)exception);
                    this.triggerListenersOnEvaluationError(rule, facts, exception);
                    if (!this.parameters.isSkipOnFirstNonTriggeredRule()) break block9;
                    LOGGER.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                    break;
                }
            }
            if (evaluationResult) {
                LOGGER.fine("Rule '" + name + "' triggered");
                this.triggerListenersAfterEvaluate(rule, facts, true);
                try {
                    this.triggerListenersBeforeExecute(rule, facts);
                    rule.execute(facts);
                    LOGGER.fine("Rule '" + name + "' performed successfully");
                    this.triggerListenersOnSuccess(rule, facts);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    LOGGER.fine("Next rule will be skipped since parameter skipOnFirstAppliedRule is set");
                }
                catch (Exception exception) {
                    LOGGER.severe("Rule '" + name + "' performed with error", (Throwable)exception);
                    this.triggerListenersOnFailure(rule, exception, facts);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    LOGGER.fine("Next rule will be skipped since parameter skipOnFirstFailedRule is set");
                }
                break;
            }
            LOGGER.fine("Rule '" + name + "' has been evaluated to false, it has not been executed");
            this.triggerListenersAfterEvaluate(rule, facts, false);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            LOGGER.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            break;
        }
    }

    private void logEngineParameters() {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine(this.parameters.toString());
    }

    private void log(Rules rules) {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine("Registered rules:");
        for (Rule rule : rules) {
            LOGGER.fine("Rule { name = '" + rule.getName() + "', description = '" + rule.getDescription() + "', priority = '" + rule.getPriority() + "'}");
        }
    }

    private void log(Facts facts) {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine("Known facts:");
        for (Fact<?> fact : facts) {
            LOGGER.fine(fact.toString());
        }
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> result = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return result;
    }

    private Map<Rule, Boolean> doCheck(Rules rules, Facts facts) {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine("Checking rules");
        HashMap<Rule, Boolean> result = new HashMap<Rule, Boolean>();
        for (Rule rule : rules) {
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            result.put(rule, rule.evaluate(facts));
        }
        return result;
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onFailure(rule, facts, exception));
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onSuccess(rule, facts));
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.beforeExecute(rule, facts));
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        return this.ruleListeners.stream().allMatch(ruleListener -> ruleListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.afterEvaluate(rule, facts, evaluationResult));
    }

    private void triggerListenersOnEvaluationError(Rule rule, Facts facts, Exception exception) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onEvaluationError(rule, facts, exception));
    }

    private void triggerListenersBeforeRules(Rules rule, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersAfterRules(Rules rule, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.afterExecute(rule, facts));
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }
}

