/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import liquibase.util.StringUtil;
import lombok.Generated;

public class RuleIteration {
    private boolean success;
    private boolean isRollback = false;
    private Map<String, String> checkRuleResults;
    private boolean validChain = true;
    private FailureReason failureReason;
    private final List<String> messages = new ArrayList<String>();

    public RuleIteration(boolean success) {
        this(success, (String[])null);
    }

    public RuleIteration(boolean success, boolean isRollback) {
        this(success, isRollback, (String[])null);
    }

    public RuleIteration(boolean success, String ... messages) {
        this.success = success;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public RuleIteration(boolean success, Map<String, String> checkRuleResults, String ... messages) {
        this.success = success;
        this.checkRuleResults = checkRuleResults;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public RuleIteration(boolean success, boolean isRollback, String ... messages) {
        this.success = success;
        this.isRollback = isRollback;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public RuleIteration(boolean success, boolean isRollback, Map<String, String> checkRuleResults, boolean validChain, String ... messages) {
        this.success = success;
        this.isRollback = isRollback;
        this.checkRuleResults = checkRuleResults;
        this.validChain = validChain;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public RuleIteration(FailureReason failureReason) {
        this(failureReason, (String[])null);
    }

    public RuleIteration(FailureReason failureReason, String ... messages) {
        this(failureReason, false, messages);
    }

    public RuleIteration(FailureReason failureReason, boolean isRollback, String ... messages) {
        this(false, failureReason, isRollback, messages);
    }

    public RuleIteration(boolean success, FailureReason failureReason, boolean isRollback, String ... messages) {
        this.success = success;
        this.failureReason = failureReason;
        this.isRollback = isRollback;
        if (messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean addMessage(String message) {
        return this.messages.add(message);
    }

    public boolean isRollback() {
        return this.isRollback;
    }

    public Map<String, String> getCheckRuleResults() {
        return this.checkRuleResults;
    }

    public String buildDisplayMessage() {
        return StringUtil.join(this.getMessages(), (String)";");
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public boolean isValidChain() {
        return this.validChain;
    }

    @Generated
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @Generated
    public List<String> getMessages() {
        return this.messages;
    }

    public static enum FailureReason {
        SQL_PARSING,
        INVALID_CHANGELOG_FILE_TYPE,
        OBJECT_TYPE_NOT_APPLICABLE,
        SCRIPT_NOT_FOUND,
        SCRIPT_HAS_ERROR,
        CUSTOM_CHECKS_DISABLED;

    }
}

