/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.storedlogic.AbstractChangedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;

public class ChangedFunctionChangeGenerator
extends AbstractChangedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Function.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        if (objectDifferences.isDifferent("body")) {
            CreateFunctionChange replaceFunctionChange = new CreateFunctionChange();
            replaceFunctionChange.setFunctionBody(this.convertToReplace(((StoredDatabaseLogic)databaseObject).getBody(), database2));
            replaceFunctionChange.setFunctionName(Function.getFunctionName(databaseObject));
            if (diffOutputControl.getIncludeCatalog()) {
                replaceFunctionChange.setCatalogName(databaseObject.getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                replaceFunctionChange.setSchemaName(databaseObject.getSchema().getName());
            }
            if (database instanceof MSSQLDatabase) {
                replaceFunctionChange.setReplaceIfExists(true);
            }
            return AbstractMissingStoredLogicChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{replaceFunctionChange});
        }
        return null;
    }
}

