/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration.pro;

import java.util.Arrays;
import java.util.List;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.ConfiguredValueModifier;
import liquibase.configuration.ProvidedValue;
import liquibase.util.StringUtil;

public class SecretsVaultJarExistenceCheck<DataType>
implements ConfiguredValueModifier<DataType> {
    private static final List<Provider> PROVIDERS = Arrays.asList(new Provider("hashicorp", "org.liquibase.ext.vaults.hashicorp.HashiCorpValueModifier", "HashiCorp Vault"), new Provider("aws-secrets", "org.liquibase.ext.secrets.aws.AWSSecretsValueModifier", "AWS Secrets Manager"), new Provider("aws-ssm", "org.liquibase.ext.secrets.aws.AWSSystemManagerValueModifier", "AWS Systems Manager"));

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void override(ConfiguredValue<DataType> object) {
        ProvidedValue finalValue = object.getProvidedValue();
        String finalValueString = null;
        if (finalValue != null && finalValue.getValue() != null) {
            finalValueString = finalValue.getValue().toString().toLowerCase();
        }
        if (StringUtil.isNotEmpty(finalValueString)) {
            for (Provider provider : PROVIDERS) {
                provider.checkForJar(finalValueString);
            }
        }
    }

    private static class Provider {
        private final String providerPrefix;
        private final String className;
        private final String displayName;
        private boolean errorMessagePrinted = false;

        private Provider(String providerPrefix, String className, String displayName) {
            this.providerPrefix = providerPrefix;
            this.className = className;
            this.displayName = displayName;
        }

        public String getProviderPrefix() {
            return this.providerPrefix;
        }

        public String getClassName() {
            return this.className;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void checkForJar(String finalValueString) {
            if (!this.errorMessagePrinted && finalValueString.startsWith(this.getProviderPrefix()) && !this.isClassExists()) {
                String msg = "The " + this.getDisplayName() + " extension JAR is not available on the classpath.";
                Scope.getCurrentScope().getLog(this.getClass()).severe(msg);
                Scope.getCurrentScope().getUI().sendErrorMessage(msg);
                this.errorMessagePrinted = true;
            }
        }

        public boolean isClassExists() {
            try {
                Class.forName(this.getClassName());
                return true;
            }
            catch (ClassNotFoundException ignored) {
                return false;
            }
        }
    }
}

