/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collection;
import java.util.function.Predicate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;

public class ImplicitNullCheckFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Match<AbstractInsnNode> IGNORE = InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class));
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> GET_CLASS_NULL_CHECK = QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.methodCallTo(ClassName.fromClass(Object.class), "getClass").and(InstructionMatchers.isInstruction((SlotRead<AbstractInsnNode>)MUTATED_INSTRUCTION.read()))).then(InstructionMatchers.opCode(87)).then(InstructionMatchers.isA(LabelNode.class).negate()).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(IGNORE).withDebug(false));
    private ClassTree currentClass;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (Predicate)Prelude.not(this.isAnImplicitNullCheck()));
    }

    private Predicate<MutationDetails> isAnImplicitNullCheck() {
        return a -> {
            int instruction = a.getInstructionIndex();
            MethodTree method = this.currentClass.methods().stream().filter(MethodMatchers.forLocation(a.getId().getLocation())).findFirst().get();
            AbstractInsnNode mutatedInstruction = method.instructions().get(instruction);
            Context context = Context.start(method.instructions(), (boolean)false);
            context.store(MUTATED_INSTRUCTION.write(), (Object)mutatedInstruction);
            return GET_CLASS_NULL_CHECK.matches(method.instructions(), context);
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }
}

