/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.timeout;

import java.util.Collection;
import java.util.function.Predicate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class AvoidForLoopCounterFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Match<AbstractInsnNode> IGNORE = InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class).or(InstructionMatchers.opCode(180)));
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> MUTATED_FOR_COUNTER = QueryStart.match((Match)Match.never()).or(AvoidForLoopCounterFilter.conditionalAtEnd()).or(AvoidForLoopCounterFilter.conditionalAtStart()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(IGNORE).withDebug(false));
    private ClassTree currentClass;

    private static SequenceQuery<AbstractInsnNode> conditionalAtEnd() {
        Slot counterVariable = Slot.create(Integer.class);
        Slot loopStart = Slot.create(LabelNode.class);
        Slot loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.anIStore((SlotWrite<Integer>)counterVariable.write()).and(InstructionMatchers.debug("end_counter"))).then(InstructionMatchers.isA(LabelNode.class)).then(InstructionMatchers.gotoLabel((SlotWrite<LabelNode>)loopEnd.write())).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write()).and(InstructionMatchers.debug("loop start"))).zeroOrMore(AvoidForLoopCounterFilter.anything()).then(AvoidForLoopCounterFilter.targetInstruction((Slot<Integer>)counterVariable).and(InstructionMatchers.debug("target"))).then(InstructionMatchers.labelNode((SlotRead<LabelNode>)loopEnd.read()).and(InstructionMatchers.debug("loop end"))).then(InstructionMatchers.anILoadOf((SlotRead<Integer>)counterVariable.read()).and(InstructionMatchers.debug("read"))).zeroOrMore(AvoidForLoopCounterFilter.anything()).then(AvoidForLoopCounterFilter.loadsAnIntegerToCompareTo()).then(InstructionMatchers.aConditionalJumpTo((Slot<LabelNode>)loopStart).and(InstructionMatchers.debug("jump"))).zeroOrMore(AvoidForLoopCounterFilter.anything());
    }

    private static SequenceQuery<AbstractInsnNode> conditionalAtStart() {
        Slot counterVariable = Slot.create(Integer.class);
        Slot loopStart = Slot.create(LabelNode.class);
        Slot loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.anIStore((SlotWrite<Integer>)counterVariable.write()).and(InstructionMatchers.debug("store"))).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write()).and(InstructionMatchers.debug("label"))).then(InstructionMatchers.anILoadOf((SlotRead<Integer>)counterVariable.read()).and(InstructionMatchers.debug("load"))).zeroOrMore(QueryStart.match(InstructionMatchers.opCode(25))).then(AvoidForLoopCounterFilter.loadsAnIntegerToCompareTo().and(InstructionMatchers.debug("push"))).then(InstructionMatchers.jumpsTo((SlotWrite<LabelNode>)loopEnd.write()).and(InstructionMatchers.aConditionalJump())).then(InstructionMatchers.isA(LabelNode.class)).zeroOrMore(AvoidForLoopCounterFilter.anything()).then(AvoidForLoopCounterFilter.targetInstruction((Slot<Integer>)counterVariable).and(InstructionMatchers.debug("target"))).then(InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read()).and(InstructionMatchers.debug("jump"))).then(InstructionMatchers.labelNode((SlotRead<LabelNode>)loopEnd.read())).zeroOrMore(AvoidForLoopCounterFilter.anything());
    }

    private static Match<AbstractInsnNode> loadsAnIntegerToCompareTo() {
        return InstructionMatchers.opCode(16).or(AvoidForLoopCounterFilter.integerMethodCall()).or(AvoidForLoopCounterFilter.arrayLength());
    }

    private static Match<AbstractInsnNode> arrayLength() {
        return InstructionMatchers.opCode(190);
    }

    private static SequenceQuery<AbstractInsnNode> anything() {
        return QueryStart.match(InstructionMatchers.anyInstruction());
    }

    private static Match<AbstractInsnNode> integerMethodCall() {
        return InstructionMatchers.isA(MethodInsnNode.class);
    }

    private static Match<AbstractInsnNode> targetInstruction(Slot<Integer> counterVariable) {
        return InstructionMatchers.incrementsVariable((SlotRead<Integer>)counterVariable.read()).and(InstructionMatchers.isInstruction((SlotRead<AbstractInsnNode>)MUTATED_INSTRUCTION.read()));
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (Predicate)Prelude.not(this.mutatesAForLoopCounter()));
    }

    private Predicate<MutationDetails> mutatesAForLoopCounter() {
        return a -> {
            int instruction = a.getInstructionIndex();
            MethodTree method = this.currentClass.methods().stream().filter(MethodMatchers.forLocation(a.getId().getLocation())).findFirst().get();
            AbstractInsnNode mutatedInstruction = method.instructions().get(instruction);
            Context context = Context.start(method.instructions(), (boolean)false);
            context.store(MUTATED_INSTRUCTION.write(), (Object)mutatedInstruction);
            return MUTATED_FOR_COUNTER.matches(method.instructions(), context);
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }
}

