/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.timeout;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.build.intercept.timeout.InfiniteLoopFilter;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class InfiniteForLoopFilter
extends InfiniteLoopFilter {
    private static final boolean DEBUG = false;
    private static final Match<AbstractInsnNode> IGNORE = InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class));
    static final SequenceMatcher<AbstractInsnNode> INFINITE_LOOP = QueryStart.match((Match)Match.never()).or(InfiniteForLoopFilter.countingLoopWithoutWriteConditionalAtStart()).or(InfiniteForLoopFilter.countingLoopWithoutWriteConditionAtEnd()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(IGNORE).withDebug(false));

    @Override
    SequenceMatcher<AbstractInsnNode> infiniteLoopMatcher() {
        return INFINITE_LOOP;
    }

    @Override
    boolean couldCauseInfiniteLoop(MethodTree method, MutationDetails each) {
        AbstractInsnNode instruction = method.instructions().get(each.getInstructionIndex());
        return instruction.getOpcode() == 132;
    }

    private static SequenceQuery<AbstractInsnNode> countingLoopWithoutWriteConditionalAtStart() {
        Slot counterVariable = Slot.create(Integer.class);
        Slot loopStart = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.anIntegerConstant().and(InstructionMatchers.debug("constant"))).zeroOrMore(QueryStart.match(InstructionMatchers.opCode(96))).then(InstructionMatchers.anIStore((SlotWrite<Integer>)counterVariable.write()).and(InstructionMatchers.debug("counter"))).zeroOrMore(QueryStart.match((Match)InstructionMatchers.opCode(21).or(InstructionMatchers.opCode(25).or(InstructionMatchers.opCode(54)).or(InstructionMatchers.methodCall())))).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write()).and(InstructionMatchers.debug("label"))).then(InstructionMatchers.anILoadOf((SlotRead<Integer>)counterVariable.read()).and(InstructionMatchers.debug("load"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop((Slot<Integer>)counterVariable)).zeroOrMore(QueryStart.match((Match)InstructionMatchers.opCode(21).or(InstructionMatchers.opCode(25).or(InstructionMatchers.methodCall())))).then(InstructionMatchers.aConditionalJump().and(InstructionMatchers.debug("jump"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop((Slot<Integer>)counterVariable)).then(InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> countingLoopWithoutWriteConditionAtEnd() {
        Slot counterVariable = Slot.create(Integer.class);
        Slot loopStart = Slot.create(LabelNode.class);
        Slot loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.anIntegerConstant()).then(InstructionMatchers.anIStore((SlotWrite<Integer>)counterVariable.write()).and(InstructionMatchers.debug("counter"))).then(InstructionMatchers.isA(LabelNode.class)).then(InstructionMatchers.gotoLabel((SlotWrite<LabelNode>)loopEnd.write())).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write()).and(InstructionMatchers.debug("loop start"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop((Slot<Integer>)counterVariable)).then(InstructionMatchers.labelNode((SlotRead<LabelNode>)loopEnd.read()).and(InstructionMatchers.debug("loop end"))).then(InstructionMatchers.anILoadOf((SlotRead<Integer>)counterVariable.read()).and(InstructionMatchers.debug("read"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop((Slot<Integer>)counterVariable)).then(InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read()).and(InstructionMatchers.debug("jump"))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> doesNotBreakLoop(Slot<Integer> counterVariable) {
        return QueryStart.match((Match)InstructionMatchers.anIStoreTo((SlotRead<Integer>)counterVariable.read()).and(InstructionMatchers.debug("broken by store")).or(InstructionMatchers.incrementsVariable((SlotRead<Integer>)counterVariable.read())).negate());
    }
}

