/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.timeout;

import java.util.Iterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.intercept.timeout.InfiniteLoopFilter;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class InfiniteIteratorLoopFilter
extends InfiniteLoopFilter {
    private static final boolean DEBUG = false;
    static final SequenceMatcher<AbstractInsnNode> INFINITE_LOOP = QueryStart.match((Match)Match.never()).or(InfiniteIteratorLoopFilter.inifniteIteratorLoop()).or(InfiniteIteratorLoopFilter.infiniteIteratorLoopJavac()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(IGNORE).withDebug(false));

    @Override
    SequenceMatcher<AbstractInsnNode> infiniteLoopMatcher() {
        return INFINITE_LOOP;
    }

    @Override
    boolean couldCauseInfiniteLoop(MethodTree method, MutationDetails each) {
        AbstractInsnNode instruction = method.instructions().get(each.getInstructionIndex());
        return this.isIteratorNext(instruction);
    }

    private static SequenceQuery<AbstractInsnNode> doesNotBreakIteratorLoop() {
        return QueryStart.match((Match)InstructionMatchers.methodCallTo(ClassName.fromClass(Iterator.class), "next").negate());
    }

    private boolean isIteratorNext(AbstractInsnNode instruction) {
        return InstructionMatchers.methodCallTo(ClassName.fromClass(Iterator.class), "next").test(null, (Object)instruction);
    }

    private static SequenceQuery<AbstractInsnNode> inifniteIteratorLoop() {
        Slot loopStart = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.methodCallThatReturns(ClassName.fromString((String)"java/util/Iterator"))).then(InstructionMatchers.opCode(58)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.aJump()).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write())).oneOrMore(InfiniteIteratorLoopFilter.doesNotBreakIteratorLoop()).then(InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read())).zeroOrMore(QueryStart.match((Match)InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read()).negate()));
    }

    private static SequenceQuery<AbstractInsnNode> infiniteIteratorLoopJavac() {
        Slot loopStart = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.methodCallThatReturns(ClassName.fromString((String)"java/util/Iterator"))).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.aLabelNode((SlotWrite<LabelNode>)loopStart.write())).oneOrMore(InfiniteIteratorLoopFilter.doesNotBreakIteratorLoop()).then(InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read())).zeroOrMore(QueryStart.match((Match)InstructionMatchers.jumpsTo((SlotRead<LabelNode>)loopStart.read()).negate()));
    }
}

