/* 
 * Created on Aug 2, 2005
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright @2005 the original author or authors.
 */
package org.springmodules.cache;

import org.springframework.core.NestedRuntimeException;

/**
 * Understands an unexpected error that ocurred while accessing a cache.
 * 
 * @author Alex Ruiz
 */
public abstract class CacheException extends NestedRuntimeException {

  public CacheException(String msg) {
    super(msg);
  }

  public CacheException(String msg, Throwable cause) {
    super(msg, cause);
  }

}
