/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket;

import java.util.Arrays;
import java.util.List;
import zmq.Ctx;
import zmq.Options;
import zmq.SocketBase;
import zmq.io.HelloMsgSession;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.net.Address;
import zmq.socket.Channel;
import zmq.socket.Pair;
import zmq.socket.Peer;
import zmq.socket.Raw;
import zmq.socket.Stream;
import zmq.socket.clientserver.Client;
import zmq.socket.clientserver.Server;
import zmq.socket.pipeline.Pull;
import zmq.socket.pipeline.Push;
import zmq.socket.pubsub.Pub;
import zmq.socket.pubsub.Sub;
import zmq.socket.pubsub.XPub;
import zmq.socket.pubsub.XSub;
import zmq.socket.radiodish.Dish;
import zmq.socket.radiodish.Radio;
import zmq.socket.reqrep.Dealer;
import zmq.socket.reqrep.Rep;
import zmq.socket.reqrep.Req;
import zmq.socket.reqrep.Router;
import zmq.socket.scattergather.Gather;
import zmq.socket.scattergather.Scatter;

public enum Sockets {
    PAIR(new String[]{"PAIR"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Pair(parent, tid, sid);
        }
    }
    ,
    PUB(new String[]{"SUB", "XSUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Pub(parent, tid, sid);
        }
    }
    ,
    SUB(new String[]{"PUB", "XPUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Sub(parent, tid, sid);
        }
    }
    ,
    REQ(new String[]{"REP", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Req(parent, tid, sid);
        }

        @Override
        public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            return new Req.ReqSession(ioThread, connect, socket, options, addr);
        }
    }
    ,
    REP(new String[]{"REQ", "DEALER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Rep(parent, tid, sid);
        }
    }
    ,
    DEALER(new String[]{"REP", "DEALER", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Dealer(parent, tid, sid);
        }
    }
    ,
    ROUTER(new String[]{"REQ", "DEALER", "ROUTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Router(parent, tid, sid);
        }
    }
    ,
    PULL(new String[]{"PUSH"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Pull(parent, tid, sid);
        }
    }
    ,
    PUSH(new String[]{"PULL"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Push(parent, tid, sid);
        }
    }
    ,
    XPUB(new String[]{"SUB", "XSUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new XPub(parent, tid, sid);
        }
    }
    ,
    XSUB(new String[]{"PUB", "XPUB"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new XSub(parent, tid, sid);
        }
    }
    ,
    STREAM(new String[0]){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Stream(parent, tid, sid);
        }
    }
    ,
    SERVER(new String[]{"CLIENT"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Server(parent, tid, sid);
        }
    }
    ,
    CLIENT(new String[]{"SERVER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Client(parent, tid, sid);
        }
    }
    ,
    RADIO(new String[]{"DISH"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Radio(parent, tid, sid);
        }

        @Override
        public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            return new Radio.RadioSession(ioThread, connect, socket, options, addr);
        }
    }
    ,
    DISH(new String[]{"RADIO"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Dish(parent, tid, sid);
        }

        @Override
        public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            return new Dish.DishSession(ioThread, connect, socket, options, addr);
        }
    }
    ,
    CHANNEL(new String[]{"CHANNEL"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Channel(parent, tid, sid);
        }
    }
    ,
    PEER(new String[]{"PEER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Peer(parent, tid, sid);
        }
    }
    ,
    RAW(new String[0]){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Raw(parent, tid, sid);
        }
    }
    ,
    SCATTER(new String[]{"GATHER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Scatter(parent, tid, sid);
        }
    }
    ,
    GATHER(new String[]{"SCATTER"}){

        @Override
        SocketBase create(Ctx parent, int tid, int sid) {
            return new Gather(parent, tid, sid);
        }
    };

    private final List<String> compatible;

    private Sockets(String ... compatible) {
        this.compatible = Arrays.asList(compatible);
    }

    abstract SocketBase create(Ctx var1, int var2, int var3);

    public SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
        if (options.canSendHelloMsg && options.helloMsg != null) {
            return new HelloMsgSession(ioThread, connect, socket, options, addr);
        }
        return new SessionBase(ioThread, connect, socket, options, addr);
    }

    public static SessionBase createSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
        return Sockets.values()[options.type].create(ioThread, connect, socket, options, addr);
    }

    public static SocketBase create(int socketType, Ctx parent, int tid, int sid) {
        return Sockets.values()[socketType].create(parent, tid, sid);
    }

    public static String name(int socketType) {
        return Sockets.values()[socketType].name();
    }

    public static Sockets fromType(int socketType) {
        return Sockets.values()[socketType];
    }

    public static boolean compatible(int self, String peer) {
        return Sockets.values()[self].compatible.contains(peer);
    }
}

