/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.xml.internal.unmarshall;

import java.io.IOException;
import java.util.HashMap;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.awscore.DefaultAwsResponseMetadata;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.SdkStandardLogger;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlProtocolUnmarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class AwsXmlResponseHandler<T extends AwsResponse>
implements HttpResponseHandler<T> {
    private static final Logger log = Logger.loggerFor(AwsXmlResponseHandler.class);
    private final XmlProtocolUnmarshaller unmarshaller;
    private final Function<SdkHttpFullResponse, SdkPojo> pojoSupplier;
    private final boolean needsConnectionLeftOpen;

    public AwsXmlResponseHandler(XmlProtocolUnmarshaller unmarshaller, Function<SdkHttpFullResponse, SdkPojo> pojoSupplier, boolean needsConnectionLeftOpen) {
        this.unmarshaller = unmarshaller;
        this.pojoSupplier = pojoSupplier;
        this.needsConnectionLeftOpen = needsConnectionLeftOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) throws Exception {
        try {
            T t = this.unmarshallResponse(response);
            return t;
        }
        finally {
            if (!this.needsConnectionLeftOpen) {
                this.closeStream(response);
            }
        }
    }

    private void closeStream(SdkHttpFullResponse response) {
        response.content().ifPresent(i -> {
            try {
                i.close();
            }
            catch (IOException e) {
                log.warn(() -> "Error closing HTTP content.", (Throwable)e);
            }
        });
    }

    private T unmarshallResponse(SdkHttpFullResponse response) throws Exception {
        SdkStandardLogger.REQUEST_LOGGER.trace(() -> "Parsing service response XML.");
        AwsResponse result = (AwsResponse)this.unmarshaller.unmarshall(this.pojoSupplier.apply(response), response);
        SdkStandardLogger.REQUEST_LOGGER.trace(() -> "Done parsing service response.");
        AwsResponseMetadata responseMetadata = this.generateResponseMetadata((SdkHttpResponse)response);
        return (T)result.toBuilder().responseMetadata(responseMetadata).build();
    }

    private AwsResponseMetadata generateResponseMetadata(SdkHttpResponse response) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("AWS_REQUEST_ID", response.firstMatchingHeader("x-amzn-RequestId").orElse(null));
        response.headers().forEach((key, value) -> {
            String cfr_ignored_0 = (String)metadata.put((String)key, value.get(0));
        });
        return DefaultAwsResponseMetadata.create(metadata);
    }

    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }
}

