/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ProxyConfiguration
implements ToCopyableBuilder<Builder, ProxyConfiguration> {
    private final String scheme;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final Set<String> nonProxyHosts;

    private ProxyConfiguration(BuilderImpl builder) {
        this.scheme = builder.scheme;
        this.host = builder.host;
        this.port = builder.port;
        this.username = builder.username;
        this.password = builder.password;
        this.nonProxyHosts = Collections.unmodifiableSet(builder.nonProxyHosts);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Set<String> nonProxyHosts() {
        return this.nonProxyHosts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.nonProxyHosts.equals(that.nonProxyHosts);
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.nonProxyHosts.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static final class BuilderImpl
    implements Builder {
        private String scheme;
        private String host;
        private int port;
        private String username;
        private String password;
        private Set<String> nonProxyHosts = Collections.emptySet();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration proxyConfiguration) {
            this.scheme = proxyConfiguration.scheme;
            this.host = proxyConfiguration.host;
            this.port = proxyConfiguration.port;
            this.nonProxyHosts = new HashSet<String>(proxyConfiguration.nonProxyHosts);
            this.username = proxyConfiguration.username;
            this.password = proxyConfiguration.password;
        }

        @Override
        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder nonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts != null ? new HashSet<String>(nonProxyHosts) : Collections.emptySet();
            return this;
        }

        @Override
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder host(String var1);

        public Builder port(int var1);

        public Builder scheme(String var1);

        public Builder nonProxyHosts(Set<String> var1);

        public Builder username(String var1);

        public Builder password(String var1);
    }
}

