/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.ConfiguredS3SdkHttpRequest;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverContext;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverFactory;

@SdkInternalApi
public final class EndpointAddressInterceptor
implements ExecutionInterceptor {
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        boolean endpointOverridden = Boolean.TRUE.equals(executionAttributes.getAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN));
        URI endpointOverride = endpointOverridden ? (URI)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT) : null;
        S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
        S3EndpointResolverContext resolverContext = S3EndpointResolverContext.builder().request(context.httpRequest()).originalRequest(context.request()).region((Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION)).endpointOverride(endpointOverride).serviceConfiguration(serviceConfiguration).build();
        String bucketName = context.request().getValueForField("Bucket", String.class).orElse(null);
        ConfiguredS3SdkHttpRequest configuredRequest = S3EndpointResolverFactory.getEndpointResolver(bucketName).applyEndpointConfiguration(resolverContext);
        configuredRequest.signingRegionModification().ifPresent(region -> executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, region));
        configuredRequest.signingServiceModification().ifPresent(name -> executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, name));
        return configuredRequest.sdkHttpRequest();
    }
}

