/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.ErrorDetails;
import software.amazon.awssdk.services.s3.model.RecordExpiration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JournalTableConfigurationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JournalTableConfigurationResult> {
    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableStatus").getter(JournalTableConfigurationResult.getter(JournalTableConfigurationResult::tableStatus)).setter(JournalTableConfigurationResult.setter(Builder::tableStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").unmarshallLocationName("TableStatus").build(), RequiredTrait.create()}).build();
    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(JournalTableConfigurationResult.getter(JournalTableConfigurationResult::error)).setter(JournalTableConfigurationResult.setter(Builder::error)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").unmarshallLocationName("Error").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(JournalTableConfigurationResult.getter(JournalTableConfigurationResult::tableName)).setter(JournalTableConfigurationResult.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").unmarshallLocationName("TableName").build(), RequiredTrait.create()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(JournalTableConfigurationResult.getter(JournalTableConfigurationResult::tableArn)).setter(JournalTableConfigurationResult.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").unmarshallLocationName("TableArn").build()}).build();
    private static final SdkField<RecordExpiration> RECORD_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecordExpiration").getter(JournalTableConfigurationResult.getter(JournalTableConfigurationResult::recordExpiration)).setter(JournalTableConfigurationResult.setter(Builder::recordExpiration)).constructor(RecordExpiration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordExpiration").unmarshallLocationName("RecordExpiration").build(), RequiredTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_STATUS_FIELD, ERROR_FIELD, TABLE_NAME_FIELD, TABLE_ARN_FIELD, RECORD_EXPIRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JournalTableConfigurationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tableStatus;
    private final ErrorDetails error;
    private final String tableName;
    private final String tableArn;
    private final RecordExpiration recordExpiration;

    private JournalTableConfigurationResult(BuilderImpl builder) {
        this.tableStatus = builder.tableStatus;
        this.error = builder.error;
        this.tableName = builder.tableName;
        this.tableArn = builder.tableArn;
        this.recordExpiration = builder.recordExpiration;
    }

    public final String tableStatus() {
        return this.tableStatus;
    }

    public final ErrorDetails error() {
        return this.error;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final RecordExpiration recordExpiration() {
        return this.recordExpiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordExpiration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JournalTableConfigurationResult)) {
            return false;
        }
        JournalTableConfigurationResult other = (JournalTableConfigurationResult)obj;
        return Objects.equals(this.tableStatus(), other.tableStatus()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.recordExpiration(), other.recordExpiration());
    }

    public final String toString() {
        return ToString.builder((String)"JournalTableConfigurationResult").add("TableStatus", (Object)this.tableStatus()).add("Error", (Object)this.error()).add("TableName", (Object)this.tableName()).add("TableArn", (Object)this.tableArn()).add("RecordExpiration", (Object)this.recordExpiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableStatus": {
                return Optional.ofNullable(clazz.cast(this.tableStatus()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "RecordExpiration": {
                return Optional.ofNullable(clazz.cast(this.recordExpiration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TableStatus", TABLE_STATUS_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        map.put("RecordExpiration", RECORD_EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JournalTableConfigurationResult, T> g) {
        return obj -> g.apply((JournalTableConfigurationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableStatus;
        private ErrorDetails error;
        private String tableName;
        private String tableArn;
        private RecordExpiration recordExpiration;

        private BuilderImpl() {
        }

        private BuilderImpl(JournalTableConfigurationResult model) {
            this.tableStatus(model.tableStatus);
            this.error(model.error);
            this.tableName(model.tableName);
            this.tableArn(model.tableArn);
            this.recordExpiration(model.recordExpiration);
        }

        public final String getTableStatus() {
            return this.tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        public final ErrorDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final RecordExpiration.Builder getRecordExpiration() {
            return this.recordExpiration != null ? this.recordExpiration.toBuilder() : null;
        }

        public final void setRecordExpiration(RecordExpiration.BuilderImpl recordExpiration) {
            this.recordExpiration = recordExpiration != null ? recordExpiration.build() : null;
        }

        @Override
        public final Builder recordExpiration(RecordExpiration recordExpiration) {
            this.recordExpiration = recordExpiration;
            return this;
        }

        public JournalTableConfigurationResult build() {
            return new JournalTableConfigurationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JournalTableConfigurationResult> {
        public Builder tableStatus(String var1);

        public Builder error(ErrorDetails var1);

        default public Builder error(Consumer<ErrorDetails.Builder> error) {
            return this.error((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(error)).build());
        }

        public Builder tableName(String var1);

        public Builder tableArn(String var1);

        public Builder recordExpiration(RecordExpiration var1);

        default public Builder recordExpiration(Consumer<RecordExpiration.Builder> recordExpiration) {
            return this.recordExpiration((RecordExpiration)((RecordExpiration.Builder)RecordExpiration.builder().applyMutation(recordExpiration)).build());
        }
    }
}

