/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.cache.OneCallerBlocks;
import software.amazon.awssdk.utils.cache.RefreshResult;

@SdkProtectedApi
public final class CachedSupplier<T>
implements Supplier<T>,
SdkAutoCloseable {
    private static final Duration BLOCKING_REFRESH_MAX_WAIT = Duration.ofSeconds(5L);
    private final Lock refreshLock = new ReentrantLock();
    private final PrefetchStrategy prefetchStrategy;
    private volatile RefreshResult<T> cachedValue = RefreshResult.builder(null).staleTime(Instant.MIN).prefetchTime(Instant.MIN).build();
    private final Supplier<RefreshResult<T>> valueSupplier;

    private CachedSupplier(Builder<T> builder) {
        this.valueSupplier = Validate.notNull(((Builder)builder).supplier, "builder.supplier", new Object[0]);
        this.prefetchStrategy = Validate.notNull(((Builder)builder).prefetchStrategy, "builder.prefetchStrategy", new Object[0]);
    }

    public static <T> Builder<T> builder(Supplier<RefreshResult<T>> valueSupplier) {
        return new Builder(valueSupplier);
    }

    @Override
    public T get() {
        if (this.cacheIsStale()) {
            this.refreshCache();
        } else if (this.shouldInitiateCachePrefetch()) {
            this.prefetchCache();
        }
        return this.cachedValue.value();
    }

    private boolean cacheIsStale() {
        if (this.cachedValue.staleTime() == null) {
            return false;
        }
        return Instant.now().isAfter(this.cachedValue.staleTime());
    }

    private boolean shouldInitiateCachePrefetch() {
        if (this.cachedValue.prefetchTime() == null) {
            return false;
        }
        return Instant.now().isAfter(this.cachedValue.prefetchTime());
    }

    private void prefetchCache() {
        this.prefetchStrategy.prefetch(this::refreshCache);
    }

    private void refreshCache() {
        try {
            boolean lockAcquired = this.refreshLock.tryLock(BLOCKING_REFRESH_MAX_WAIT.getSeconds(), TimeUnit.SECONDS);
            try {
                if (this.cacheIsStale() || this.shouldInitiateCachePrefetch()) {
                    this.cachedValue = this.valueSupplier.get();
                }
            }
            finally {
                if (lockAcquired) {
                    this.refreshLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            this.handleInterruptedException("Interrupted waiting to refresh the value.", e);
        }
    }

    private void handleInterruptedException(String message, InterruptedException cause) {
        Thread.currentThread().interrupt();
        throw new IllegalStateException(message, cause);
    }

    @Override
    public void close() {
        this.prefetchStrategy.close();
    }

    @FunctionalInterface
    public static interface PrefetchStrategy
    extends SdkAutoCloseable {
        public void prefetch(Runnable var1);

        @Override
        default public void close() {
        }
    }

    public static final class Builder<T> {
        private final Supplier<RefreshResult<T>> supplier;
        private PrefetchStrategy prefetchStrategy = new OneCallerBlocks();

        private Builder(Supplier<RefreshResult<T>> supplier) {
            this.supplier = supplier;
        }

        public Builder<T> prefetchStrategy(PrefetchStrategy prefetchStrategy) {
            this.prefetchStrategy = prefetchStrategy;
            return this;
        }

        public CachedSupplier<T> build() {
            return new CachedSupplier(this);
        }
    }
}

