// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleResponse
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.StsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class AssumeRoleOperationDeserializer: HttpDeserialize<AssumeRoleResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AssumeRoleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssumeRoleError(context, call)
        }
        val builder = AssumeRoleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssumeRoleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAssumeRoleError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw StsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MalformedPolicyDocument" -> MalformedPolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "RegionDisabledException" -> RegionDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "PackedPolicyTooLarge" -> PackedPolicyTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        else -> StsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssumeRoleOperationBody(builder: AssumeRoleResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AssumeRoleResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("AssumeRoleResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap AssumeRole response")
    }
    // end unwrap response wrapper

    val ASSUMEDROLEUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AssumedRoleUser"))
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Credentials"))
    val PACKEDPOLICYSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("PackedPolicySize"))
    val SOURCEIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SourceIdentity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://sts.amazonaws.com/doc/2011-06-15/"))
        trait(XmlSerialName("AssumeRoleResult"))
        field(ASSUMEDROLEUSER_DESCRIPTOR)
        field(CREDENTIALS_DESCRIPTOR)
        field(PACKEDPOLICYSIZE_DESCRIPTOR)
        field(SOURCEIDENTITY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSUMEDROLEUSER_DESCRIPTOR.index -> builder.assumedRoleUser = deserializeAssumedRoleUserDocument(deserializer)
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeCredentialsDocument(deserializer)
                PACKEDPOLICYSIZE_DESCRIPTOR.index -> builder.packedPolicySize = deserializeInt()
                SOURCEIDENTITY_DESCRIPTOR.index -> builder.sourceIdentity = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
