// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * A collection of parts associated with a multipart upload.
 */
public class GetObjectAttributesParts private constructor(builder: Builder) {
    /**
     * Indicates whether the returned list of parts is truncated. A value of `true` indicates that the list was truncated. A list can be truncated if the number of parts exceeds the limit returned in the `MaxParts` element.
     */
    public val isTruncated: kotlin.Boolean? = builder.isTruncated
    /**
     * The maximum number of parts allowed in the response.
     */
    public val maxParts: kotlin.Int? = builder.maxParts
    /**
     * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the `PartNumberMarker` request parameter in a subsequent request.
     */
    public val nextPartNumberMarker: kotlin.String? = builder.nextPartNumberMarker
    /**
     * The marker for the current part.
     */
    public val partNumberMarker: kotlin.String? = builder.partNumberMarker
    /**
     * A container for elements related to a particular part. A response can contain zero or more `Parts` elements.
     *
     * + **General purpose buckets** - For `GetObjectAttributes`, if a additional checksum (including `x-amz-checksum-crc32`, `x-amz-checksum-crc32c`, `x-amz-checksum-sha1`, or `x-amz-checksum-sha256`) isn't applied to the object specified in the request, the response doesn't return `Part`.
     * + **Directory buckets** - For `GetObjectAttributes`, no matter whether a additional checksum is applied to the object specified in the request, the response returns `Part`.
     */
    public val parts: List<ObjectPart>? = builder.parts
    /**
     * The total number of parts.
     */
    public val totalPartsCount: kotlin.Int? = builder.totalPartsCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetObjectAttributesParts(")
        append("isTruncated=$isTruncated,")
        append("maxParts=$maxParts,")
        append("nextPartNumberMarker=$nextPartNumberMarker,")
        append("partNumberMarker=$partNumberMarker,")
        append("parts=$parts,")
        append("totalPartsCount=$totalPartsCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated?.hashCode() ?: 0
        result = 31 * result + (maxParts ?: 0)
        result = 31 * result + (nextPartNumberMarker?.hashCode() ?: 0)
        result = 31 * result + (partNumberMarker?.hashCode() ?: 0)
        result = 31 * result + (parts?.hashCode() ?: 0)
        result = 31 * result + (totalPartsCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetObjectAttributesParts

        if (isTruncated != other.isTruncated) return false
        if (maxParts != other.maxParts) return false
        if (nextPartNumberMarker != other.nextPartNumberMarker) return false
        if (partNumberMarker != other.partNumberMarker) return false
        if (parts != other.parts) return false
        if (totalPartsCount != other.totalPartsCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the returned list of parts is truncated. A value of `true` indicates that the list was truncated. A list can be truncated if the number of parts exceeds the limit returned in the `MaxParts` element.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * The maximum number of parts allowed in the response.
         */
        public var maxParts: kotlin.Int? = null
        /**
         * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the `PartNumberMarker` request parameter in a subsequent request.
         */
        public var nextPartNumberMarker: kotlin.String? = null
        /**
         * The marker for the current part.
         */
        public var partNumberMarker: kotlin.String? = null
        /**
         * A container for elements related to a particular part. A response can contain zero or more `Parts` elements.
         *
         * + **General purpose buckets** - For `GetObjectAttributes`, if a additional checksum (including `x-amz-checksum-crc32`, `x-amz-checksum-crc32c`, `x-amz-checksum-sha1`, or `x-amz-checksum-sha256`) isn't applied to the object specified in the request, the response doesn't return `Part`.
         * + **Directory buckets** - For `GetObjectAttributes`, no matter whether a additional checksum is applied to the object specified in the request, the response returns `Part`.
         */
        public var parts: List<ObjectPart>? = null
        /**
         * The total number of parts.
         */
        public var totalPartsCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts) : this() {
            this.isTruncated = x.isTruncated
            this.maxParts = x.maxParts
            this.nextPartNumberMarker = x.nextPartNumberMarker
            this.partNumberMarker = x.partNumberMarker
            this.parts = x.parts
            this.totalPartsCount = x.totalPartsCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetObjectAttributesParts = GetObjectAttributesParts(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
