// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetObjectRequest private constructor(builder: Builder) {
    /**
     * The bucket name containing the object.
     *
     * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
     *
     * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * **Object Lambda access points** - When you use this action with an Object Lambda access point, you must direct requests to the Object Lambda access point hostname. The Object Lambda access point hostname takes the form *AccessPointName*-*AccountId*.s3-object-lambda.*Region*.amazonaws.com.
     *
     * Access points and Object Lambda access points are not supported by directory buckets.
     *
     * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * To retrieve the checksum, this mode must be enabled.
     */
    public val checksumMode: aws.sdk.kotlin.services.s3.model.ChecksumMode? = builder.checksumMode
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Return the object only if its entity tag (ETag) is the same as the one specified in this header; otherwise, return a `412 Precondition Failed` error.
     *
     * If both of the `If-Match` and `If-Unmodified-Since` headers are present in the request as follows: `If-Match` condition evaluates to `true`, and; `If-Unmodified-Since` condition evaluates to `false`; then, S3 returns `200 OK` and the data requested.
     *
     * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
     */
    public val ifMatch: kotlin.String? = builder.ifMatch
    /**
     * Return the object only if it has been modified since the specified time; otherwise, return a `304 Not Modified` error.
     *
     * If both of the `If-None-Match` and `If-Modified-Since` headers are present in the request as follows:` If-None-Match` condition evaluates to `false`, and; `If-Modified-Since` condition evaluates to `true`; then, S3 returns `304 Not Modified` status code.
     *
     * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
     */
    public val ifModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.ifModifiedSince
    /**
     * Return the object only if its entity tag (ETag) is different from the one specified in this header; otherwise, return a `304 Not Modified` error.
     *
     * If both of the `If-None-Match` and `If-Modified-Since` headers are present in the request as follows:` If-None-Match` condition evaluates to `false`, and; `If-Modified-Since` condition evaluates to `true`; then, S3 returns `304 Not Modified` HTTP status code.
     *
     * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
     */
    public val ifNoneMatch: kotlin.String? = builder.ifNoneMatch
    /**
     * Return the object only if it has not been modified since the specified time; otherwise, return a `412 Precondition Failed` error.
     *
     * If both of the `If-Match` and `If-Unmodified-Since` headers are present in the request as follows: `If-Match` condition evaluates to `true`, and; `If-Unmodified-Since` condition evaluates to `false`; then, S3 returns `200 OK` and the data requested.
     *
     * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
     */
    public val ifUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.ifUnmodifiedSince
    /**
     * Key of the object to get.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.
     */
    public val partNumber: kotlin.Int? = builder.partNumber
    /**
     * Downloads the specified byte range of an object. For more information about the HTTP Range header, see [https://www.rfc-editor.org/rfc/rfc9110.html#name-range](https://www.rfc-editor.org/rfc/rfc9110.html#name-range).
     *
     * Amazon S3 doesn't support retrieving multiple ranges of data per `GET` request.
     */
    public val range: kotlin.String? = builder.range
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * Sets the `Cache-Control` header of the response.
     */
    public val responseCacheControl: kotlin.String? = builder.responseCacheControl
    /**
     * Sets the `Content-Disposition` header of the response.
     */
    public val responseContentDisposition: kotlin.String? = builder.responseContentDisposition
    /**
     * Sets the `Content-Encoding` header of the response.
     */
    public val responseContentEncoding: kotlin.String? = builder.responseContentEncoding
    /**
     * Sets the `Content-Language` header of the response.
     */
    public val responseContentLanguage: kotlin.String? = builder.responseContentLanguage
    /**
     * Sets the `Content-Type` header of the response.
     */
    public val responseContentType: kotlin.String? = builder.responseContentType
    /**
     * Sets the `Expires` header of the response.
     */
    public val responseExpires: aws.smithy.kotlin.runtime.time.Instant? = builder.responseExpires
    /**
     * Specifies the algorithm to use when decrypting the object (for example, `AES256`).
     *
     * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:
     * + `x-amz-server-side-encryption-customer-algorithm`
     * + `x-amz-server-side-encryption-customer-key`
     * + `x-amz-server-side-encryption-customer-key-MD5`
     *
     * For more information about SSE-C, see [Server-Side Encryption (Using Customer-Provided Encryption Keys)](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * Specifies the customer-provided encryption key that you originally provided for Amazon S3 to encrypt the data before storing it. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
     *
     * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:
     * + `x-amz-server-side-encryption-customer-algorithm`
     * + `x-amz-server-side-encryption-customer-key`
     * + `x-amz-server-side-encryption-customer-key-MD5`
     *
     * For more information about SSE-C, see [Server-Side Encryption (Using Customer-Provided Encryption Keys)](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val sseCustomerKey: kotlin.String? = builder.sseCustomerKey
    /**
     * Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     *
     * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:
     * + `x-amz-server-side-encryption-customer-algorithm`
     * + `x-amz-server-side-encryption-customer-key`
     * + `x-amz-server-side-encryption-customer-key-MD5`
     *
     * For more information about SSE-C, see [Server-Side Encryption (Using Customer-Provided Encryption Keys)](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5
    /**
     * Version ID used to reference a specific version of the object.
     *
     * By default, the `GetObject` operation returns the current version of an object. To return a different version, use the `versionId` subresource.
     *
     * + If you include a `versionId` in your request header, you must have the `s3:GetObjectVersion` permission to access a specific version of an object. The `s3:GetObject` permission is not required in this scenario.
     * + If you request the current version of an object without a specific `versionId` in the request header, only the `s3:GetObject` permission is required. The `s3:GetObjectVersion` permission is not required in this scenario.
     * + **Directory buckets** - S3 Versioning isn't enabled and supported for directory buckets. For this API operation, only the `null` value of the version ID is supported by directory buckets. You can only specify `null` to the `versionId` query parameter in the request.
     * For more information about versioning, see [PutBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html).
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetObjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetObjectRequest(")
        append("bucket=$bucket,")
        append("checksumMode=$checksumMode,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("ifMatch=$ifMatch,")
        append("ifModifiedSince=$ifModifiedSince,")
        append("ifNoneMatch=$ifNoneMatch,")
        append("ifUnmodifiedSince=$ifUnmodifiedSince,")
        append("key=$key,")
        append("partNumber=$partNumber,")
        append("range=$range,")
        append("requestPayer=$requestPayer,")
        append("responseCacheControl=$responseCacheControl,")
        append("responseContentDisposition=$responseContentDisposition,")
        append("responseContentEncoding=$responseContentEncoding,")
        append("responseContentLanguage=$responseContentLanguage,")
        append("responseContentType=$responseContentType,")
        append("responseExpires=$responseExpires,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKey=*** Sensitive Data Redacted ***,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (checksumMode?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (ifModifiedSince?.hashCode() ?: 0)
        result = 31 * result + (ifNoneMatch?.hashCode() ?: 0)
        result = 31 * result + (ifUnmodifiedSince?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (partNumber ?: 0)
        result = 31 * result + (range?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (responseCacheControl?.hashCode() ?: 0)
        result = 31 * result + (responseContentDisposition?.hashCode() ?: 0)
        result = 31 * result + (responseContentEncoding?.hashCode() ?: 0)
        result = 31 * result + (responseContentLanguage?.hashCode() ?: 0)
        result = 31 * result + (responseContentType?.hashCode() ?: 0)
        result = 31 * result + (responseExpires?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetObjectRequest

        if (bucket != other.bucket) return false
        if (checksumMode != other.checksumMode) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (ifMatch != other.ifMatch) return false
        if (ifModifiedSince != other.ifModifiedSince) return false
        if (ifNoneMatch != other.ifNoneMatch) return false
        if (ifUnmodifiedSince != other.ifUnmodifiedSince) return false
        if (key != other.key) return false
        if (partNumber != other.partNumber) return false
        if (range != other.range) return false
        if (requestPayer != other.requestPayer) return false
        if (responseCacheControl != other.responseCacheControl) return false
        if (responseContentDisposition != other.responseContentDisposition) return false
        if (responseContentEncoding != other.responseContentEncoding) return false
        if (responseContentLanguage != other.responseContentLanguage) return false
        if (responseContentType != other.responseContentType) return false
        if (responseExpires != other.responseExpires) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKey != other.sseCustomerKey) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetObjectRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The bucket name containing the object.
         *
         * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
         *
         * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * **Object Lambda access points** - When you use this action with an Object Lambda access point, you must direct requests to the Object Lambda access point hostname. The Object Lambda access point hostname takes the form *AccessPointName*-*AccountId*.s3-object-lambda.*Region*.amazonaws.com.
         *
         * Access points and Object Lambda access points are not supported by directory buckets.
         *
         * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * To retrieve the checksum, this mode must be enabled.
         */
        public var checksumMode: aws.sdk.kotlin.services.s3.model.ChecksumMode? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * Return the object only if its entity tag (ETag) is the same as the one specified in this header; otherwise, return a `412 Precondition Failed` error.
         *
         * If both of the `If-Match` and `If-Unmodified-Since` headers are present in the request as follows: `If-Match` condition evaluates to `true`, and; `If-Unmodified-Since` condition evaluates to `false`; then, S3 returns `200 OK` and the data requested.
         *
         * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
         */
        public var ifMatch: kotlin.String? = null
        /**
         * Return the object only if it has been modified since the specified time; otherwise, return a `304 Not Modified` error.
         *
         * If both of the `If-None-Match` and `If-Modified-Since` headers are present in the request as follows:` If-None-Match` condition evaluates to `false`, and; `If-Modified-Since` condition evaluates to `true`; then, S3 returns `304 Not Modified` status code.
         *
         * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
         */
        public var ifModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Return the object only if its entity tag (ETag) is different from the one specified in this header; otherwise, return a `304 Not Modified` error.
         *
         * If both of the `If-None-Match` and `If-Modified-Since` headers are present in the request as follows:` If-None-Match` condition evaluates to `false`, and; `If-Modified-Since` condition evaluates to `true`; then, S3 returns `304 Not Modified` HTTP status code.
         *
         * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
         */
        public var ifNoneMatch: kotlin.String? = null
        /**
         * Return the object only if it has not been modified since the specified time; otherwise, return a `412 Precondition Failed` error.
         *
         * If both of the `If-Match` and `If-Unmodified-Since` headers are present in the request as follows: `If-Match` condition evaluates to `true`, and; `If-Unmodified-Since` condition evaluates to `false`; then, S3 returns `200 OK` and the data requested.
         *
         * For more information about conditional requests, see [RFC 7232](https://tools.ietf.org/html/rfc7232).
         */
        public var ifUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Key of the object to get.
         */
        public var key: kotlin.String? = null
        /**
         * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.
         */
        public var partNumber: kotlin.Int? = null
        /**
         * Downloads the specified byte range of an object. For more information about the HTTP Range header, see [https://www.rfc-editor.org/rfc/rfc9110.html#name-range](https://www.rfc-editor.org/rfc/rfc9110.html#name-range).
         *
         * Amazon S3 doesn't support retrieving multiple ranges of data per `GET` request.
         */
        public var range: kotlin.String? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * Sets the `Cache-Control` header of the response.
         */
        public var responseCacheControl: kotlin.String? = null
        /**
         * Sets the `Content-Disposition` header of the response.
         */
        public var responseContentDisposition: kotlin.String? = null
        /**
         * Sets the `Content-Encoding` header of the response.
         */
        public var responseContentEncoding: kotlin.String? = null
        /**
         * Sets the `Content-Language` header of the response.
         */
        public var responseContentLanguage: kotlin.String? = null
        /**
         * Sets the `Content-Type` header of the response.
         */
        public var responseContentType: kotlin.String? = null
        /**
         * Sets the `Expires` header of the response.
         */
        public var responseExpires: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the algorithm to use when decrypting the object (for example, `AES256`).
         *
         * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:
         * + `x-amz-server-side-encryption-customer-algorithm`
         * + `x-amz-server-side-encryption-customer-key`
         * + `x-amz-server-side-encryption-customer-key-MD5`
         *
         * For more information about SSE-C, see [Server-Side Encryption (Using Customer-Provided Encryption Keys)](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * Specifies the customer-provided encryption key that you originally provided for Amazon S3 to encrypt the data before storing it. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
         *
         * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:
         * + `x-amz-server-side-encryption-customer-algorithm`
         * + `x-amz-server-side-encryption-customer-key`
         * + `x-amz-server-side-encryption-customer-key-MD5`
         *
         * For more information about SSE-C, see [Server-Side Encryption (Using Customer-Provided Encryption Keys)](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var sseCustomerKey: kotlin.String? = null
        /**
         * Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
         *
         * If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:
         * + `x-amz-server-side-encryption-customer-algorithm`
         * + `x-amz-server-side-encryption-customer-key`
         * + `x-amz-server-side-encryption-customer-key-MD5`
         *
         * For more information about SSE-C, see [Server-Side Encryption (Using Customer-Provided Encryption Keys)](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var sseCustomerKeyMd5: kotlin.String? = null
        /**
         * Version ID used to reference a specific version of the object.
         *
         * By default, the `GetObject` operation returns the current version of an object. To return a different version, use the `versionId` subresource.
         *
         * + If you include a `versionId` in your request header, you must have the `s3:GetObjectVersion` permission to access a specific version of an object. The `s3:GetObject` permission is not required in this scenario.
         * + If you request the current version of an object without a specific `versionId` in the request header, only the `s3:GetObject` permission is required. The `s3:GetObjectVersion` permission is not required in this scenario.
         * + **Directory buckets** - S3 Versioning isn't enabled and supported for directory buckets. For this API operation, only the `null` value of the version ID is supported by directory buckets. You can only specify `null` to the `versionId` query parameter in the request.
         * For more information about versioning, see [PutBucketVersioning](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html).
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetObjectRequest) : this() {
            this.bucket = x.bucket
            this.checksumMode = x.checksumMode
            this.expectedBucketOwner = x.expectedBucketOwner
            this.ifMatch = x.ifMatch
            this.ifModifiedSince = x.ifModifiedSince
            this.ifNoneMatch = x.ifNoneMatch
            this.ifUnmodifiedSince = x.ifUnmodifiedSince
            this.key = x.key
            this.partNumber = x.partNumber
            this.range = x.range
            this.requestPayer = x.requestPayer
            this.responseCacheControl = x.responseCacheControl
            this.responseContentDisposition = x.responseContentDisposition
            this.responseContentEncoding = x.responseContentEncoding
            this.responseContentLanguage = x.responseContentLanguage
            this.responseContentType = x.responseContentType
            this.responseExpires = x.responseExpires
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKey = x.sseCustomerKey
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetObjectRequest = GetObjectRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
