// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object consists of data and its descriptive metadata.
 */
public class Object private constructor(builder: Builder) {
    /**
     * The algorithm that was used to create a checksum of the object.
     */
    public val checksumAlgorithm: List<ChecksumAlgorithm>? = builder.checksumAlgorithm
    /**
     * The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:
     * + Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.
     * + Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.
     * + If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption. If an object is larger than 16 MB, the Amazon Web Services Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest.
     *
     * **Directory buckets** - MD5 is not supported by directory buckets.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * The name that you assign to an object. You use the object key to retrieve the object.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Creation date of the object.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The owner of the object
     *
     * **Directory buckets** - The bucket owner is returned as the object owner.
     */
    public val owner: aws.sdk.kotlin.services.s3.model.Owner? = builder.owner
    /**
     * Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see [ Working with archived objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
     */
    public val restoreStatus: aws.sdk.kotlin.services.s3.model.RestoreStatus? = builder.restoreStatus
    /**
     * Size in bytes of the object
     */
    public val size: kotlin.Long? = builder.size
    /**
     * The class of storage used to store the object.
     *
     * **Directory buckets** - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
     */
    public val storageClass: aws.sdk.kotlin.services.s3.model.ObjectStorageClass? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Object = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Object(")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("eTag=$eTag,")
        append("key=$key,")
        append("lastModified=$lastModified,")
        append("owner=$owner,")
        append("restoreStatus=$restoreStatus,")
        append("size=$size,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = checksumAlgorithm?.hashCode() ?: 0
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (restoreStatus?.hashCode() ?: 0)
        result = 31 * result + (size?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Object

        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (eTag != other.eTag) return false
        if (key != other.key) return false
        if (lastModified != other.lastModified) return false
        if (owner != other.owner) return false
        if (restoreStatus != other.restoreStatus) return false
        if (size != other.size) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Object = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The algorithm that was used to create a checksum of the object.
         */
        public var checksumAlgorithm: List<ChecksumAlgorithm>? = null
        /**
         * The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:
         * + Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.
         * + Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.
         * + If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption. If an object is larger than 16 MB, the Amazon Web Services Management Console will upload or copy that object as a Multipart Upload, and therefore the ETag will not be an MD5 digest.
         *
         * **Directory buckets** - MD5 is not supported by directory buckets.
         */
        public var eTag: kotlin.String? = null
        /**
         * The name that you assign to an object. You use the object key to retrieve the object.
         */
        public var key: kotlin.String? = null
        /**
         * Creation date of the object.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The owner of the object
         *
         * **Directory buckets** - The bucket owner is returned as the object owner.
         */
        public var owner: aws.sdk.kotlin.services.s3.model.Owner? = null
        /**
         * Specifies the restoration status of an object. Objects in certain storage classes must be restored before they can be retrieved. For more information about these storage classes and how to work with archived objects, see [ Working with archived objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/archived-objects.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
         */
        public var restoreStatus: aws.sdk.kotlin.services.s3.model.RestoreStatus? = null
        /**
         * Size in bytes of the object
         */
        public var size: kotlin.Long? = null
        /**
         * The class of storage used to store the object.
         *
         * **Directory buckets** - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
         */
        public var storageClass: aws.sdk.kotlin.services.s3.model.ObjectStorageClass? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Object) : this() {
            this.checksumAlgorithm = x.checksumAlgorithm
            this.eTag = x.eTag
            this.key = x.key
            this.lastModified = x.lastModified
            this.owner = x.owner
            this.restoreStatus = x.restoreStatus
            this.size = x.size
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Object = Object(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Owner] inside the given [block]
         */
        public fun owner(block: aws.sdk.kotlin.services.s3.model.Owner.Builder.() -> kotlin.Unit) {
            this.owner = aws.sdk.kotlin.services.s3.model.Owner.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.RestoreStatus] inside the given [block]
         */
        public fun restoreStatus(block: aws.sdk.kotlin.services.s3.model.RestoreStatus.Builder.() -> kotlin.Unit) {
            this.restoreStatus = aws.sdk.kotlin.services.s3.model.RestoreStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
