// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Describes the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied. If you don't specify a customer managed key at configuration, Amazon S3 automatically creates an Amazon Web Services KMS key in your Amazon Web Services account the first time that you add an object encrypted with SSE-KMS to a bucket. By default, Amazon S3 uses this KMS key for SSE-KMS. For more information, see [PUT Bucket encryption](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html) in the *Amazon S3 API Reference*.
 */
public class ServerSideEncryptionByDefault private constructor(builder: Builder) {
    /**
     * Amazon Web Services Key Management Service (KMS) customer Amazon Web Services KMS key ID to use for the default encryption. This parameter is allowed if and only if `SSEAlgorithm` is set to `aws:kms`.
     *
     * You can specify the key ID, key alias, or the Amazon Resource Name (ARN) of the KMS key.
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key Alias: `alias/alias-name`
     *
     * If you use a key ID, you can run into a LogDestination undeliverable error when creating a VPC flow log.
     *
     * If you are using encryption with cross-account or Amazon Web Services service operations you must use a fully qualified KMS key ARN. For more information, see [Using encryption for cross-account operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy).
     *
     * Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in Amazon Web Services KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Amazon Web Services Key Management Service Developer Guide*.
     */
    public val kmsMasterKeyId: kotlin.String? = builder.kmsMasterKeyId
    /**
     * Server-side encryption algorithm to use for the default encryption.
     */
    public val sseAlgorithm: aws.sdk.kotlin.services.s3.model.ServerSideEncryption = requireNotNull(builder.sseAlgorithm) { "A non-null value must be provided for sseAlgorithm" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerSideEncryptionByDefault(")
        append("kmsMasterKeyId=*** Sensitive Data Redacted ***,")
        append("sseAlgorithm=$sseAlgorithm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsMasterKeyId?.hashCode() ?: 0
        result = 31 * result + (sseAlgorithm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerSideEncryptionByDefault

        if (kmsMasterKeyId != other.kmsMasterKeyId) return false
        if (sseAlgorithm != other.sseAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon Web Services Key Management Service (KMS) customer Amazon Web Services KMS key ID to use for the default encryption. This parameter is allowed if and only if `SSEAlgorithm` is set to `aws:kms`.
         *
         * You can specify the key ID, key alias, or the Amazon Resource Name (ARN) of the KMS key.
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key Alias: `alias/alias-name`
         *
         * If you use a key ID, you can run into a LogDestination undeliverable error when creating a VPC flow log.
         *
         * If you are using encryption with cross-account or Amazon Web Services service operations you must use a fully qualified KMS key ARN. For more information, see [Using encryption for cross-account operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy).
         *
         * Amazon S3 only supports symmetric encryption KMS keys. For more information, see [Asymmetric keys in Amazon Web Services KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Amazon Web Services Key Management Service Developer Guide*.
         */
        public var kmsMasterKeyId: kotlin.String? = null
        /**
         * Server-side encryption algorithm to use for the default encryption.
         */
        public var sseAlgorithm: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault) : this() {
            this.kmsMasterKeyId = x.kmsMasterKeyId
            this.sseAlgorithm = x.sseAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ServerSideEncryptionByDefault = ServerSideEncryptionByDefault(this)

        internal fun correctErrors(): Builder {
            if (sseAlgorithm == null) sseAlgorithm = ServerSideEncryption.SdkUnknown("no value provided")
            return this
        }
    }
}
