// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The established temporary security credentials of the session.
 *
 * **Directory buckets** - These session credentials are only supported for the authentication and authorization of Zonal endpoint APIs on directory buckets.
 */
public class SessionCredentials private constructor(builder: Builder) {
    /**
     * A unique identifier that's associated with a secret access key. The access key ID and the secret access key are used together to sign programmatic Amazon Web Services requests cryptographically.
     */
    public val accessKeyId: kotlin.String = requireNotNull(builder.accessKeyId) { "A non-null value must be provided for accessKeyId" }
    /**
     * Temporary security credentials expire after a specified interval. After temporary credentials expire, any calls that you make with those credentials will fail. So you must generate a new set of temporary credentials. Temporary credentials cannot be extended or refreshed beyond the original specified interval.
     */
    public val expiration: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expiration) { "A non-null value must be provided for expiration" }
    /**
     * A key that's used with the access key ID to cryptographically sign programmatic Amazon Web Services requests. Signing a request identifies the sender and prevents the request from being altered.
     */
    public val secretAccessKey: kotlin.String = requireNotNull(builder.secretAccessKey) { "A non-null value must be provided for secretAccessKey" }
    /**
     * A part of the temporary security credentials. The session token is used to validate the temporary security credentials.
     */
    public val sessionToken: kotlin.String = requireNotNull(builder.sessionToken) { "A non-null value must be provided for sessionToken" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.SessionCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionCredentials(")
        append("accessKeyId=$accessKeyId,")
        append("expiration=$expiration,")
        append("secretAccessKey=*** Sensitive Data Redacted ***,")
        append("sessionToken=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId.hashCode()
        result = 31 * result + (expiration.hashCode())
        result = 31 * result + (secretAccessKey.hashCode())
        result = 31 * result + (sessionToken.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionCredentials

        if (accessKeyId != other.accessKeyId) return false
        if (expiration != other.expiration) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.SessionCredentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier that's associated with a secret access key. The access key ID and the secret access key are used together to sign programmatic Amazon Web Services requests cryptographically.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * Temporary security credentials expire after a specified interval. After temporary credentials expire, any calls that you make with those credentials will fail. So you must generate a new set of temporary credentials. Temporary credentials cannot be extended or refreshed beyond the original specified interval.
         */
        public var expiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A key that's used with the access key ID to cryptographically sign programmatic Amazon Web Services requests. Signing a request identifies the sender and prevents the request from being altered.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * A part of the temporary security credentials. The session token is used to validate the temporary security credentials.
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.SessionCredentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.expiration = x.expiration
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.SessionCredentials = SessionCredentials(this)

        internal fun correctErrors(): Builder {
            if (accessKeyId == null) accessKeyId = ""
            if (expiration == null) expiration = Instant.fromEpochSeconds(0)
            if (secretAccessKey == null) secretAccessKey = ""
            if (sessionToken == null) sessionToken = ""
            return this
        }
    }
}
