// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

public class UploadPartCopyRequest private constructor(builder: Builder) {
    /**
     * The bucket name.
     *
     * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
     *
     * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * Access points and Object Lambda access points are not supported by directory buckets.
     *
     * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an [access point](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
     * + For objects not accessed through an access point, specify the name of the source bucket and key of the source object, separated by a slash (/). For example, to copy the object `reports/january.pdf` from the bucket `awsexamplebucket`, use `awsexamplebucket/reports/january.pdf`. The value must be URL-encoded.
     * + For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, to copy the object `reports/january.pdf` through access point `my-access-point` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf`. The value must be URL encoded.   + Amazon S3 supports copy operations using Access points only when the source and destination buckets are in the same Amazon Web Services Region.
     *    + Access points are not supported by directory buckets.
     * Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>`. For example, to copy the object `reports/january.pdf` through outpost `my-outpost` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf`. The value must be URL-encoded.
     *
     * If your bucket has versioning enabled, you could have multiple versions of the same object. By default, `x-amz-copy-source` identifies the current version of the source object to copy. To copy a specific version of the source object to copy, append `?versionId=<version-id>` to the `x-amz-copy-source` request header (for example, `x-amz-copy-source: /awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893`).
     *
     * If the current version is a delete marker and you don't specify a versionId in the `x-amz-copy-source` request header, Amazon S3 returns a `404 Not Found` error, because the object does not exist. If you specify versionId in the `x-amz-copy-source` and the versionId is a delete marker, Amazon S3 returns an HTTP `400 Bad Request` error, because you are not allowed to specify a delete marker as a version for the `x-amz-copy-source`.
     *
     * **Directory buckets** - S3 Versioning isn't enabled and supported for directory buckets.
     */
    public val copySource: kotlin.String? = builder.copySource
    /**
     * Copies the object if its entity tag (ETag) matches the specified tag.
     *
     * If both of the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request as follows:
     *
     * `x-amz-copy-source-if-match` condition evaluates to `true`, and;
     *
     * `x-amz-copy-source-if-unmodified-since` condition evaluates to `false`;
     *
     * Amazon S3 returns `200 OK` and copies the data.
     */
    public val copySourceIfMatch: kotlin.String? = builder.copySourceIfMatch
    /**
     * Copies the object if it has been modified since the specified time.
     *
     * If both of the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request as follows:
     *
     * `x-amz-copy-source-if-none-match` condition evaluates to `false`, and;
     *
     * `x-amz-copy-source-if-modified-since` condition evaluates to `true`;
     *
     * Amazon S3 returns `412 Precondition Failed` response code.
     */
    public val copySourceIfModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.copySourceIfModifiedSince
    /**
     * Copies the object if its entity tag (ETag) is different than the specified ETag.
     *
     * If both of the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request as follows:
     *
     * `x-amz-copy-source-if-none-match` condition evaluates to `false`, and;
     *
     * `x-amz-copy-source-if-modified-since` condition evaluates to `true`;
     *
     * Amazon S3 returns `412 Precondition Failed` response code.
     */
    public val copySourceIfNoneMatch: kotlin.String? = builder.copySourceIfNoneMatch
    /**
     * Copies the object if it hasn't been modified since the specified time.
     *
     * If both of the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request as follows:
     *
     * `x-amz-copy-source-if-match` condition evaluates to `true`, and;
     *
     * `x-amz-copy-source-if-unmodified-since` condition evaluates to `false`;
     *
     * Amazon S3 returns `200 OK` and copies the data.
     */
    public val copySourceIfUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.copySourceIfUnmodifiedSince
    /**
     * The range of bytes to copy from the source object. The range value must use the form bytes=first-last, where the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that you want to copy the first 10 bytes of the source. You can copy a range only if the source object is greater than 5 MB.
     */
    public val copySourceRange: kotlin.String? = builder.copySourceRange
    /**
     * Specifies the algorithm to use when decrypting the source object (for example, `AES256`).
     *
     * This functionality is not supported when the source object is in a directory bucket.
     */
    public val copySourceSseCustomerAlgorithm: kotlin.String? = builder.copySourceSseCustomerAlgorithm
    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
     *
     * This functionality is not supported when the source object is in a directory bucket.
     */
    public val copySourceSseCustomerKey: kotlin.String? = builder.copySourceSseCustomerKey
    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     *
     * This functionality is not supported when the source object is in a directory bucket.
     */
    public val copySourceSseCustomerKeyMd5: kotlin.String? = builder.copySourceSseCustomerKeyMd5
    /**
     * The account ID of the expected destination bucket owner. If the account ID that you provide does not match the actual owner of the destination bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The account ID of the expected source bucket owner. If the account ID that you provide does not match the actual owner of the source bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedSourceBucketOwner: kotlin.String? = builder.expectedSourceBucketOwner
    /**
     * Object key for which the multipart upload was initiated.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Part number of part being copied. This is a positive integer between 1 and 10,000.
     */
    public val partNumber: kotlin.Int? = builder.partNumber
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * Specifies the algorithm to use when encrypting the object (for example, AES256).
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header. This must be the same encryption key specified in the initiate multipart upload request.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val sseCustomerKey: kotlin.String? = builder.sseCustomerKey
    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5
    /**
     * Upload ID identifying the multipart upload whose part is being copied.
     */
    public val uploadId: kotlin.String? = builder.uploadId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.UploadPartCopyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadPartCopyRequest(")
        append("bucket=$bucket,")
        append("copySource=$copySource,")
        append("copySourceIfMatch=$copySourceIfMatch,")
        append("copySourceIfModifiedSince=$copySourceIfModifiedSince,")
        append("copySourceIfNoneMatch=$copySourceIfNoneMatch,")
        append("copySourceIfUnmodifiedSince=$copySourceIfUnmodifiedSince,")
        append("copySourceRange=$copySourceRange,")
        append("copySourceSseCustomerAlgorithm=$copySourceSseCustomerAlgorithm,")
        append("copySourceSseCustomerKey=*** Sensitive Data Redacted ***,")
        append("copySourceSseCustomerKeyMd5=$copySourceSseCustomerKeyMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("expectedSourceBucketOwner=$expectedSourceBucketOwner,")
        append("key=$key,")
        append("partNumber=$partNumber,")
        append("requestPayer=$requestPayer,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKey=*** Sensitive Data Redacted ***,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5,")
        append("uploadId=$uploadId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (copySource?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfMatch?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfModifiedSince?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfNoneMatch?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfUnmodifiedSince?.hashCode() ?: 0)
        result = 31 * result + (copySourceRange?.hashCode() ?: 0)
        result = 31 * result + (copySourceSseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (copySourceSseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (copySourceSseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (expectedSourceBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (partNumber ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadPartCopyRequest

        if (bucket != other.bucket) return false
        if (copySource != other.copySource) return false
        if (copySourceIfMatch != other.copySourceIfMatch) return false
        if (copySourceIfModifiedSince != other.copySourceIfModifiedSince) return false
        if (copySourceIfNoneMatch != other.copySourceIfNoneMatch) return false
        if (copySourceIfUnmodifiedSince != other.copySourceIfUnmodifiedSince) return false
        if (copySourceRange != other.copySourceRange) return false
        if (copySourceSseCustomerAlgorithm != other.copySourceSseCustomerAlgorithm) return false
        if (copySourceSseCustomerKey != other.copySourceSseCustomerKey) return false
        if (copySourceSseCustomerKeyMd5 != other.copySourceSseCustomerKeyMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (expectedSourceBucketOwner != other.expectedSourceBucketOwner) return false
        if (key != other.key) return false
        if (partNumber != other.partNumber) return false
        if (requestPayer != other.requestPayer) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKey != other.sseCustomerKey) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.UploadPartCopyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The bucket name.
         *
         * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
         *
         * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * Access points and Object Lambda access points are not supported by directory buckets.
         *
         * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an [access point](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
         * + For objects not accessed through an access point, specify the name of the source bucket and key of the source object, separated by a slash (/). For example, to copy the object `reports/january.pdf` from the bucket `awsexamplebucket`, use `awsexamplebucket/reports/january.pdf`. The value must be URL-encoded.
         * + For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, to copy the object `reports/january.pdf` through access point `my-access-point` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf`. The value must be URL encoded.   + Amazon S3 supports copy operations using Access points only when the source and destination buckets are in the same Amazon Web Services Region.
         *    + Access points are not supported by directory buckets.
         * Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>`. For example, to copy the object `reports/january.pdf` through outpost `my-outpost` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf`. The value must be URL-encoded.
         *
         * If your bucket has versioning enabled, you could have multiple versions of the same object. By default, `x-amz-copy-source` identifies the current version of the source object to copy. To copy a specific version of the source object to copy, append `?versionId=<version-id>` to the `x-amz-copy-source` request header (for example, `x-amz-copy-source: /awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893`).
         *
         * If the current version is a delete marker and you don't specify a versionId in the `x-amz-copy-source` request header, Amazon S3 returns a `404 Not Found` error, because the object does not exist. If you specify versionId in the `x-amz-copy-source` and the versionId is a delete marker, Amazon S3 returns an HTTP `400 Bad Request` error, because you are not allowed to specify a delete marker as a version for the `x-amz-copy-source`.
         *
         * **Directory buckets** - S3 Versioning isn't enabled and supported for directory buckets.
         */
        public var copySource: kotlin.String? = null
        /**
         * Copies the object if its entity tag (ETag) matches the specified tag.
         *
         * If both of the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request as follows:
         *
         * `x-amz-copy-source-if-match` condition evaluates to `true`, and;
         *
         * `x-amz-copy-source-if-unmodified-since` condition evaluates to `false`;
         *
         * Amazon S3 returns `200 OK` and copies the data.
         */
        public var copySourceIfMatch: kotlin.String? = null
        /**
         * Copies the object if it has been modified since the specified time.
         *
         * If both of the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request as follows:
         *
         * `x-amz-copy-source-if-none-match` condition evaluates to `false`, and;
         *
         * `x-amz-copy-source-if-modified-since` condition evaluates to `true`;
         *
         * Amazon S3 returns `412 Precondition Failed` response code.
         */
        public var copySourceIfModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Copies the object if its entity tag (ETag) is different than the specified ETag.
         *
         * If both of the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request as follows:
         *
         * `x-amz-copy-source-if-none-match` condition evaluates to `false`, and;
         *
         * `x-amz-copy-source-if-modified-since` condition evaluates to `true`;
         *
         * Amazon S3 returns `412 Precondition Failed` response code.
         */
        public var copySourceIfNoneMatch: kotlin.String? = null
        /**
         * Copies the object if it hasn't been modified since the specified time.
         *
         * If both of the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request as follows:
         *
         * `x-amz-copy-source-if-match` condition evaluates to `true`, and;
         *
         * `x-amz-copy-source-if-unmodified-since` condition evaluates to `false`;
         *
         * Amazon S3 returns `200 OK` and copies the data.
         */
        public var copySourceIfUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The range of bytes to copy from the source object. The range value must use the form bytes=first-last, where the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that you want to copy the first 10 bytes of the source. You can copy a range only if the source object is greater than 5 MB.
         */
        public var copySourceRange: kotlin.String? = null
        /**
         * Specifies the algorithm to use when decrypting the source object (for example, `AES256`).
         *
         * This functionality is not supported when the source object is in a directory bucket.
         */
        public var copySourceSseCustomerAlgorithm: kotlin.String? = null
        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.
         *
         * This functionality is not supported when the source object is in a directory bucket.
         */
        public var copySourceSseCustomerKey: kotlin.String? = null
        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
         *
         * This functionality is not supported when the source object is in a directory bucket.
         */
        public var copySourceSseCustomerKeyMd5: kotlin.String? = null
        /**
         * The account ID of the expected destination bucket owner. If the account ID that you provide does not match the actual owner of the destination bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * The account ID of the expected source bucket owner. If the account ID that you provide does not match the actual owner of the source bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedSourceBucketOwner: kotlin.String? = null
        /**
         * Object key for which the multipart upload was initiated.
         */
        public var key: kotlin.String? = null
        /**
         * Part number of part being copied. This is a positive integer between 1 and 10,000.
         */
        public var partNumber: kotlin.Int? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * Specifies the algorithm to use when encrypting the object (for example, AES256).
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header. This must be the same encryption key specified in the initiate multipart upload request.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var sseCustomerKey: kotlin.String? = null
        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var sseCustomerKeyMd5: kotlin.String? = null
        /**
         * Upload ID identifying the multipart upload whose part is being copied.
         */
        public var uploadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.UploadPartCopyRequest) : this() {
            this.bucket = x.bucket
            this.copySource = x.copySource
            this.copySourceIfMatch = x.copySourceIfMatch
            this.copySourceIfModifiedSince = x.copySourceIfModifiedSince
            this.copySourceIfNoneMatch = x.copySourceIfNoneMatch
            this.copySourceIfUnmodifiedSince = x.copySourceIfUnmodifiedSince
            this.copySourceRange = x.copySourceRange
            this.copySourceSseCustomerAlgorithm = x.copySourceSseCustomerAlgorithm
            this.copySourceSseCustomerKey = x.copySourceSseCustomerKey
            this.copySourceSseCustomerKeyMd5 = x.copySourceSseCustomerKeyMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.expectedSourceBucketOwner = x.expectedSourceBucketOwner
            this.key = x.key
            this.partNumber = x.partNumber
            this.requestPayer = x.requestPayer
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKey = x.sseCustomerKey
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.UploadPartCopyRequest = UploadPartCopyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
