// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.CompleteMultipartUploadResponse
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.ServerSideEncryption
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CompleteMultipartUploadOperationDeserializer: HttpDeserialize<CompleteMultipartUploadResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CompleteMultipartUploadResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCompleteMultipartUploadError(context, call)
        }
        val builder = CompleteMultipartUploadResponse.Builder()

        builder.bucketKeyEnabled = response.headers["x-amz-server-side-encryption-bucket-key-enabled"]?.toBoolean()
        builder.expiration = response.headers["x-amz-expiration"]
        builder.requestCharged = response.headers["x-amz-request-charged"]?.let { RequestCharged.fromValue(it) }
        builder.ssekmsKeyId = response.headers["x-amz-server-side-encryption-aws-kms-key-id"]
        builder.serverSideEncryption = response.headers["x-amz-server-side-encryption"]?.let { ServerSideEncryption.fromValue(it) }
        builder.versionId = response.headers["x-amz-version-id"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCompleteMultipartUploadOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCompleteMultipartUploadError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null && call.response.status == HttpStatusCode.NotFound) {
            S3ErrorDetails(code = "NotFound")
        } else {
            checkNotNull(payload){ "unable to parse error from empty response" }
            parseS3ErrorResponse(payload)
        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as 'restXml' error", ex).also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCompleteMultipartUploadOperationBody(builder: CompleteMultipartUploadResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Bucket"))
    val CHECKSUMCRC32_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChecksumCRC32"))
    val CHECKSUMCRC32C_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChecksumCRC32C"))
    val CHECKSUMSHA1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChecksumSHA1"))
    val CHECKSUMSHA256_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ChecksumSHA256"))
    val ETAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ETag"))
    val KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Key"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Location"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CompleteMultipartUploadResult"))
        trait(XmlNamespace("http://s3.amazonaws.com/doc/2006-03-01/"))
        field(BUCKET_DESCRIPTOR)
        field(CHECKSUMCRC32_DESCRIPTOR)
        field(CHECKSUMCRC32C_DESCRIPTOR)
        field(CHECKSUMSHA1_DESCRIPTOR)
        field(CHECKSUMSHA256_DESCRIPTOR)
        field(ETAG_DESCRIPTOR)
        field(KEY_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUCKET_DESCRIPTOR.index -> builder.bucket = deserializeString()
                CHECKSUMCRC32_DESCRIPTOR.index -> builder.checksumCrc32 = deserializeString()
                CHECKSUMCRC32C_DESCRIPTOR.index -> builder.checksumCrc32C = deserializeString()
                CHECKSUMSHA1_DESCRIPTOR.index -> builder.checksumSha1 = deserializeString()
                CHECKSUMSHA256_DESCRIPTOR.index -> builder.checksumSha256 = deserializeString()
                ETAG_DESCRIPTOR.index -> builder.eTag = deserializeString()
                KEY_DESCRIPTOR.index -> builder.key = deserializeString()
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
