// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.ObjectCannedAcl
import aws.sdk.kotlin.services.s3.model.ObjectLockLegalHoldStatus
import aws.sdk.kotlin.services.s3.model.ObjectLockMode
import aws.sdk.kotlin.services.s3.model.PutObjectRequest
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.sdk.kotlin.services.s3.model.ServerSideEncryption
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class PutObjectOperationSerializer: HttpSerialize<PutObjectRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                "${input.key}".split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("x-id", "PutObject")
            }
        }

        builder.headers {
            if (input.acl != null) append("x-amz-acl", input.acl.value)
            if (input.bucketKeyEnabled != null) append("x-amz-server-side-encryption-bucket-key-enabled", "${input.bucketKeyEnabled}")
            if (input.cacheControl?.isNotEmpty() == true) append("Cache-Control", input.cacheControl)
            if (input.checksumAlgorithm != null) append("x-amz-sdk-checksum-algorithm", input.checksumAlgorithm.value)
            if (input.checksumCrc32?.isNotEmpty() == true) append("x-amz-checksum-crc32", input.checksumCrc32)
            if (input.checksumCrc32C?.isNotEmpty() == true) append("x-amz-checksum-crc32c", input.checksumCrc32C)
            if (input.checksumSha1?.isNotEmpty() == true) append("x-amz-checksum-sha1", input.checksumSha1)
            if (input.checksumSha256?.isNotEmpty() == true) append("x-amz-checksum-sha256", input.checksumSha256)
            if (input.contentDisposition?.isNotEmpty() == true) append("Content-Disposition", input.contentDisposition)
            if (input.contentEncoding?.isNotEmpty() == true) append("Content-Encoding", input.contentEncoding)
            if (input.contentLanguage?.isNotEmpty() == true) append("Content-Language", input.contentLanguage)
            if (input.contentLength != null) append("Content-Length", "${input.contentLength}")
            if (input.contentMd5?.isNotEmpty() == true) append("Content-MD5", input.contentMd5)
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.expires != null) append("Expires", input.expires.format(TimestampFormat.RFC_5322))
            if (input.grantFullControl?.isNotEmpty() == true) append("x-amz-grant-full-control", input.grantFullControl)
            if (input.grantRead?.isNotEmpty() == true) append("x-amz-grant-read", input.grantRead)
            if (input.grantReadAcp?.isNotEmpty() == true) append("x-amz-grant-read-acp", input.grantReadAcp)
            if (input.grantWriteAcp?.isNotEmpty() == true) append("x-amz-grant-write-acp", input.grantWriteAcp)
            if (input.objectLockLegalHoldStatus != null) append("x-amz-object-lock-legal-hold", input.objectLockLegalHoldStatus.value)
            if (input.objectLockMode != null) append("x-amz-object-lock-mode", input.objectLockMode.value)
            if (input.objectLockRetainUntilDate != null) append("x-amz-object-lock-retain-until-date", input.objectLockRetainUntilDate.format(TimestampFormat.ISO_8601))
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKey?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key", input.sseCustomerKey)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
            if (input.ssekmsEncryptionContext?.isNotEmpty() == true) append("x-amz-server-side-encryption-context", input.ssekmsEncryptionContext)
            if (input.ssekmsKeyId?.isNotEmpty() == true) append("x-amz-server-side-encryption-aws-kms-key-id", input.ssekmsKeyId)
            if (input.serverSideEncryption != null) append("x-amz-server-side-encryption", input.serverSideEncryption.value)
            if (input.storageClass != null) append("x-amz-storage-class", input.storageClass.value)
            if (input.tagging?.isNotEmpty() == true) append("x-amz-tagging", input.tagging)
            if (input.websiteRedirectLocation?.isNotEmpty() == true) append("x-amz-website-redirect-location", input.websiteRedirectLocation)
            input.metadata?.forEach { (key, value) ->
                append("x-amz-meta-$key", value)
            }
        }

        if (input.body != null) {
            builder.body = input.body.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
