// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.AnalyticsConfiguration
import aws.sdk.kotlin.services.s3.model.PutBucketAnalyticsConfigurationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutBucketAnalyticsConfigurationOperationSerializer: HttpSerialize<PutBucketAnalyticsConfigurationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutBucketAnalyticsConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.trailingSlash = true
            parameters.decodedParameters {
                add("analytics", "")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.id != null) add("id", input.id)
            }
        }

        builder.headers {
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
        }

        if (input.analyticsConfiguration != null) {
            val payload = serializeAnalyticsConfigurationPayloadWithXmlNameAnalyticsConfiguration(input.analyticsConfiguration)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
