/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.serialization;

import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamWriter;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.serialization.LazyTagWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u001a\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010#\u001a\u00020\u0014H\u0002J\b\u0010$\u001a\u00020\u001dH\u0016J\u001a\u0010%\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000fH\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/serialization/BufferingXmlStreamWriter;", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamWriter;", "pretty", "", "(Z)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bytes", "", "getBytes", "()[B", "nsAttributes", "", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken$QualifiedName;", "", "getPretty", "()Z", "tagWriterStack", "Lkotlin/collections/ArrayDeque;", "Laws/smithy/kotlin/runtime/serde/xml/serialization/LazyTagWriter;", "text", "getText", "()Ljava/lang/String;", "attribute", "name", "value", "namespace", "endDocument", "", "endTag", "qName", "namespacePrefix", "uri", "prefix", "requireWriter", "startDocument", "startTag", "serde-xml"})
public final class BufferingXmlStreamWriter
implements XmlStreamWriter {
    private final boolean pretty;
    @NotNull
    private final StringBuilder buffer;
    @NotNull
    private final Map<XmlToken.QualifiedName, String> nsAttributes;
    @NotNull
    private final ArrayDeque<LazyTagWriter> tagWriterStack;

    public BufferingXmlStreamWriter(boolean pretty) {
        this.pretty = pretty;
        this.buffer = new StringBuilder();
        this.nsAttributes = new LinkedHashMap();
        this.tagWriterStack = new ArrayDeque();
    }

    public /* synthetic */ BufferingXmlStreamWriter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getPretty() {
        return this.pretty;
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        return StringsKt.encodeToByteArray((String)this.getText());
    }

    @Override
    @NotNull
    public String getText() {
        this.endDocument();
        String string = this.buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public XmlStreamWriter attribute(@NotNull String name, @Nullable String value, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        XmlToken.QualifiedName qName = new XmlToken.QualifiedName(name, namespace);
        this.requireWriter().attribute(qName, value);
        return this;
    }

    @Override
    public void endDocument() {
        LazyTagWriter top = (LazyTagWriter)this.tagWriterStack.lastOrNull();
        while (top != null) {
            this.endTag(top.getQName());
            top = (LazyTagWriter)this.tagWriterStack.lastOrNull();
        }
    }

    @Override
    @NotNull
    public XmlStreamWriter endTag(@NotNull String name, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.endTag(new XmlToken.QualifiedName(name, namespace));
    }

    private final XmlStreamWriter endTag(XmlToken.QualifiedName qName) {
        LazyTagWriter lazyTagWriter = (LazyTagWriter)this.tagWriterStack.removeLastOrNull();
        if (lazyTagWriter == null) {
            throw new SerializationException("Unexpected end of tag while no tags are open");
        }
        LazyTagWriter childWriter = lazyTagWriter;
        if (!Intrinsics.areEqual((Object)childWriter.getQName(), (Object)qName)) {
            throw new SerializationException("Tried to end tag " + qName + " but expected end of " + childWriter.getQName() + " tag");
        }
        if (this.tagWriterStack.isEmpty()) {
            childWriter.write(this.buffer);
        }
        return this;
    }

    @Override
    public void namespacePrefix(@NotNull String uri, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        XmlToken.QualifiedName attrQName = prefix == null ? new XmlToken.QualifiedName("xmlns", null, 2, null) : new XmlToken.QualifiedName(prefix, "xmlns");
        this.nsAttributes.put(attrQName, uri);
    }

    private final LazyTagWriter requireWriter() {
        if (this.tagWriterStack.isEmpty()) {
            throw new SerializationException("Attempted to serialize text or attribute without containing tag");
        }
        return (LazyTagWriter)this.tagWriterStack.last();
    }

    @Override
    public void startDocument() {
        this.buffer.append("<?xml version=\"1.0\"?>");
        if (this.pretty) {
            Intrinsics.checkNotNullExpressionValue((Object)this.buffer.append('\n'), (String)"append(...)");
        }
    }

    @Override
    @NotNull
    public XmlStreamWriter startTag(@NotNull String name, @Nullable String namespace) {
        LazyTagWriter currentWriter;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LazyTagWriter lazyTagWriter = currentWriter = (LazyTagWriter)this.tagWriterStack.lastOrNull();
        int currentIndent = lazyTagWriter != null ? lazyTagWriter.getIndentLevel() : -1;
        XmlToken.QualifiedName qName = new XmlToken.QualifiedName(name, namespace);
        LazyTagWriter childWriter = new LazyTagWriter(this.pretty, currentIndent + 1, qName, this.nsAttributes);
        this.nsAttributes.clear();
        LazyTagWriter lazyTagWriter2 = currentWriter;
        if (lazyTagWriter2 != null) {
            lazyTagWriter2.childTag(childWriter);
        }
        this.tagWriterStack.addLast((Object)childWriter);
        return this;
    }

    @Override
    @NotNull
    public XmlStreamWriter text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.requireWriter().text(text);
        return this;
    }

    public BufferingXmlStreamWriter() {
        this(false, 1, null);
    }
}

