/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.ARGBChannel;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.DisplacementMapRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeDisplacementMapElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feDisplacementMap";
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        float scale = AbstractSVGFilterPrimitiveElementBridge.convertNumber(filterElement, "scale", 0.0f);
        ARGBChannel xChannelSelector = SVGFeDisplacementMapElementBridge.convertChannelSelector(filterElement, "xChannelSelector", ARGBChannel.A);
        ARGBChannel yChannelSelector = SVGFeDisplacementMapElementBridge.convertChannelSelector(filterElement, "yChannelSelector", ARGBChannel.A);
        Filter in = AbstractSVGFilterPrimitiveElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in == null) {
            return null;
        }
        Filter in2 = AbstractSVGFilterPrimitiveElementBridge.getIn2(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in2 == null) {
            return null;
        }
        Rectangle2D defaultRegion = (Rectangle2D)in.getBounds2D().clone();
        defaultRegion.add(in2.getBounds2D());
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        PadRable8Bit pad = new PadRable8Bit(in, primitiveRegion, PadMode.ZERO_PAD);
        ArrayList<Filter> srcs = new ArrayList<Filter>(2);
        srcs.add(pad);
        srcs.add(in2);
        DisplacementMapRable8Bit displacementMap = new DisplacementMapRable8Bit(srcs, scale, xChannelSelector, yChannelSelector);
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters(displacementMap, filterElement);
        PadRable8Bit filter = new PadRable8Bit(displacementMap, primitiveRegion, PadMode.ZERO_PAD);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(filterElement, filter, filterMap);
        return filter;
    }

    protected static ARGBChannel convertChannelSelector(Element filterElement, String attrName, ARGBChannel defaultChannel) {
        String s = filterElement.getAttributeNS(null, attrName);
        if (s.length() == 0) {
            return defaultChannel;
        }
        if ("A".equals(s)) {
            return ARGBChannel.A;
        }
        if ("R".equals(s)) {
            return ARGBChannel.R;
        }
        if ("G".equals(s)) {
            return ARGBChannel.G;
        }
        if ("B".equals(s)) {
            return ARGBChannel.B;
        }
        throw new BridgeException(filterElement, "attribute.malformed", new Object[]{attrName, s});
    }
}

