/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractText;
import org.apache.batik.dom.ExtendedNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;

public abstract class AbstractParentNode
extends AbstractNode {
    protected ChildNodes childNodes;

    public NodeList getChildNodes() {
        return this.childNodes == null ? (this.childNodes = new ChildNodes()) : this.childNodes;
    }

    public Node getFirstChild() {
        return this.childNodes == null ? null : this.childNodes.firstChild;
    }

    public Node getLastChild() {
        return this.childNodes == null ? null : this.childNodes.lastChild;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (refChild != null && this.childNodes == null) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(refChild.getNodeType()), refChild.getNodeName()});
        }
        this.checkAndRemove(newChild, false);
        if (newChild.getNodeType() == 11) {
            Node n = newChild.getFirstChild();
            while (n != null) {
                Node ns = n.getNextSibling();
                this.insertBefore(n, refChild);
                n = ns;
            }
            return newChild;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode n = this.childNodes.insert((ExtendedNode)newChild, (ExtendedNode)refChild);
        n.setParentNode(this);
        this.nodeAdded(n);
        this.fireDOMNodeInsertedEvent(n);
        this.fireDOMSubtreeModifiedEvent();
        return n;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (this.childNodes == null) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(oldChild.getNodeType()), oldChild.getNodeName()});
        }
        this.checkAndRemove(newChild, true);
        if (newChild.getNodeType() == 11) {
            Node n = newChild.getLastChild();
            Node ps = oldChild.getNextSibling();
            if (n != null) {
                this.replaceChild(n, oldChild);
                n = n.getPreviousSibling();
            }
            while (n != null) {
                this.insertBefore(n, ps);
                n = n.getPreviousSibling();
            }
            return newChild;
        }
        this.fireDOMNodeRemovedEvent(oldChild);
        this.getCurrentDocument().nodeToBeRemoved(oldChild);
        this.nodeToBeRemoved(oldChild);
        ExtendedNode n = (ExtendedNode)newChild;
        ExtendedNode o = this.childNodes.replace(n, (ExtendedNode)oldChild);
        n.setParentNode(this);
        o.setParentNode(null);
        this.nodeAdded(n);
        this.fireDOMNodeInsertedEvent(n);
        this.fireDOMSubtreeModifiedEvent();
        return n;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this.childNodes == null || oldChild.getParentNode() != this) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(oldChild.getNodeType()), oldChild.getNodeName()});
        }
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.fireDOMNodeRemovedEvent(oldChild);
        this.getCurrentDocument().nodeToBeRemoved(oldChild);
        this.nodeToBeRemoved(oldChild);
        ExtendedNode result = this.childNodes.remove((ExtendedNode)oldChild);
        result.setParentNode(null);
        this.fireDOMSubtreeModifiedEvent();
        return result;
    }

    public Node appendChild(Node newChild) throws DOMException {
        this.checkAndRemove(newChild, false);
        if (newChild.getNodeType() == 11) {
            Node n = newChild.getFirstChild();
            while (n != null) {
                Node ns = n.getNextSibling();
                this.appendChild(n);
                n = ns;
            }
            return newChild;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode n = this.childNodes.append((ExtendedNode)newChild);
        n.setParentNode(this);
        this.nodeAdded(n);
        this.fireDOMNodeInsertedEvent(n);
        this.fireDOMSubtreeModifiedEvent();
        return n;
    }

    public boolean hasChildNodes() {
        return this.childNodes != null && this.childNodes.getLength() != 0;
    }

    public void normalize() {
        Node p = this.getFirstChild();
        if (p != null) {
            p.normalize();
            Node n = p.getNextSibling();
            while (n != null) {
                if (p.getNodeType() == 3 && n.getNodeType() == 3) {
                    String s = p.getNodeValue() + n.getNodeValue();
                    AbstractText at = (AbstractText)p;
                    at.setNodeValue(s);
                    this.removeChild(n);
                    n = p.getNextSibling();
                    continue;
                }
                n.normalize();
                p = n;
                n = n.getNextSibling();
            }
        }
    }

    public NodeList getElementsByTagName(String name) {
        if (name == null) {
            return AbstractNode.EMPTY_NODE_LIST;
        }
        AbstractDocument ad = this.getCurrentDocument();
        ElementsByTagName result = ad.getElementsByTagName(this, name);
        if (result == null) {
            result = new ElementsByTagName(name);
            ad.putElementsByTagName(this, name, result);
        }
        return result;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (localName == null) {
            return AbstractNode.EMPTY_NODE_LIST;
        }
        AbstractDocument ad = this.getCurrentDocument();
        ElementsByTagNameNS result = ad.getElementsByTagNameNS(this, namespaceURI, localName);
        if (result == null) {
            result = new ElementsByTagNameNS(namespaceURI, localName);
            ad.putElementsByTagNameNS(this, namespaceURI, localName, result);
        }
        return result;
    }

    public void fireDOMNodeInsertedIntoDocumentEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            super.fireDOMNodeInsertedIntoDocumentEvent();
            Node n = this.getFirstChild();
            while (n != null) {
                ((AbstractNode)n).fireDOMNodeInsertedIntoDocumentEvent();
                n = n.getNextSibling();
            }
        }
    }

    public void fireDOMNodeRemovedFromDocumentEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            super.fireDOMNodeRemovedFromDocumentEvent();
            Node n = this.getFirstChild();
            while (n != null) {
                ((AbstractNode)n).fireDOMNodeRemovedFromDocumentEvent();
                n = n.getNextSibling();
            }
        }
    }

    protected void nodeAdded(Node n) {
    }

    protected void nodeToBeRemoved(Node n) {
    }

    protected Node deepExport(Node n, AbstractDocument d) {
        super.deepExport(n, d);
        Node p = this.getFirstChild();
        while (p != null) {
            Node t = ((AbstractNode)p).deepExport(p.cloneNode(false), d);
            n.appendChild(t);
            p = p.getNextSibling();
        }
        return n;
    }

    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        Node p = this.getFirstChild();
        while (p != null) {
            Node t = p.cloneNode(true);
            n.appendChild(t);
            p = p.getNextSibling();
        }
        return n;
    }

    protected void fireDOMSubtreeModifiedEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            AbstractDocument de = doc;
            MutationEvent ev = (MutationEvent)de.createEvent("MutationEvents");
            ev.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)1);
            this.dispatchEvent(ev);
        }
    }

    protected void fireDOMNodeInsertedEvent(Node node) {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            AbstractDocument de = doc;
            MutationEvent ev = (MutationEvent)de.createEvent("MutationEvents");
            ev.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)2);
            AbstractNode n = (AbstractNode)node;
            n.dispatchEvent(ev);
            n.fireDOMNodeInsertedIntoDocumentEvent();
        }
    }

    protected void fireDOMNodeRemovedEvent(Node node) {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            AbstractDocument de = doc;
            MutationEvent ev = (MutationEvent)de.createEvent("MutationEvents");
            ev.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)3);
            AbstractNode n = (AbstractNode)node;
            n.dispatchEvent(ev);
            n.fireDOMNodeRemovedFromDocumentEvent();
        }
    }

    protected void checkAndRemove(Node n, boolean replace) {
        this.checkChildType(n, replace);
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (n.getOwnerDocument() != this.getCurrentDocument()) {
            throw this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        Node pn = this.getParentNode();
        while (pn != null) {
            if (pn == n) {
                throw this.createDOMException((short)4, "add.ancestor", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
            }
            pn = pn.getParentNode();
        }
        Node np = n.getParentNode();
        if (np != null) {
            np.removeChild(n);
        }
    }

    protected class ChildNodes
    implements NodeList,
    Serializable {
        protected ExtendedNode firstChild;
        protected ExtendedNode lastChild;
        protected int children;

        public Node item(int index) {
            if (index < 0 || index >= this.children) {
                return null;
            }
            if (index < this.children >> 1) {
                Node n = this.firstChild;
                int i = 0;
                while (i < index) {
                    n = n.getNextSibling();
                    ++i;
                }
                return n;
            }
            Node n = this.lastChild;
            int i = this.children - 1;
            while (i > index) {
                n = n.getPreviousSibling();
                --i;
            }
            return n;
        }

        public int getLength() {
            return this.children;
        }

        public ExtendedNode append(ExtendedNode n) {
            if (this.lastChild == null) {
                this.firstChild = n;
                this.lastChild = n;
                ++this.children;
                return n;
            }
            this.lastChild.setNextSibling(n);
            n.setPreviousSibling(this.lastChild);
            this.lastChild = n;
            ++this.children;
            return n;
        }

        public ExtendedNode insert(ExtendedNode n, ExtendedNode r) {
            if (r == null) {
                return this.append(n);
            }
            if (r == this.firstChild) {
                this.firstChild.setPreviousSibling(n);
                n.setNextSibling(this.firstChild);
                this.firstChild = n;
                ++this.children;
                return n;
            }
            ExtendedNode o = this.firstChild;
            while (o != null) {
                if (o == r) {
                    ExtendedNode ps = (ExtendedNode)r.getPreviousSibling();
                    ps.setNextSibling(n);
                    r.setPreviousSibling(n);
                    n.setNextSibling(r);
                    n.setPreviousSibling(ps);
                    ++this.children;
                    return n;
                }
                o = (ExtendedNode)o.getNextSibling();
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(r.getNodeType()), r.getNodeName()});
        }

        public ExtendedNode replace(ExtendedNode n, ExtendedNode o) {
            if (o == this.firstChild) {
                ExtendedNode t = (ExtendedNode)this.firstChild.getNextSibling();
                n.setNextSibling(t);
                if (o == this.lastChild) {
                    this.lastChild = n;
                } else {
                    t.setPreviousSibling(n);
                }
                this.firstChild.setNextSibling(null);
                this.firstChild = n;
                return o;
            }
            if (o == this.lastChild) {
                ExtendedNode t = (ExtendedNode)this.lastChild.getPreviousSibling();
                n.setPreviousSibling(t);
                t.setNextSibling(n);
                this.lastChild.setPreviousSibling(null);
                this.lastChild = n;
                return o;
            }
            ExtendedNode cn = this.firstChild;
            while (cn != null) {
                if (cn == o) {
                    ExtendedNode t = (ExtendedNode)o.getPreviousSibling();
                    n.setPreviousSibling(t);
                    t.setNextSibling(n);
                    t = (ExtendedNode)o.getNextSibling();
                    n.setNextSibling(t);
                    t.setPreviousSibling(n);
                    o.setPreviousSibling(null);
                    o.setNextSibling(null);
                    return o;
                }
                cn = (ExtendedNode)cn.getNextSibling();
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(o.getNodeType()), o.getNodeName()});
        }

        public ExtendedNode remove(ExtendedNode n) {
            if (n == this.firstChild) {
                if (n == this.lastChild) {
                    this.firstChild = null;
                    this.lastChild = null;
                    --this.children;
                    return n;
                }
                this.firstChild = (ExtendedNode)this.firstChild.getNextSibling();
                this.firstChild.setPreviousSibling(null);
                n.setNextSibling(null);
                --this.children;
                return n;
            }
            if (n == this.lastChild) {
                this.lastChild = (ExtendedNode)this.lastChild.getPreviousSibling();
                this.lastChild.setNextSibling(null);
                n.setPreviousSibling(null);
                --this.children;
                return n;
            }
            ExtendedNode o = this.firstChild;
            while (o != null) {
                if (o == n) {
                    ExtendedNode ps = (ExtendedNode)n.getPreviousSibling();
                    ExtendedNode ns = (ExtendedNode)n.getNextSibling();
                    ps.setNextSibling(ns);
                    ns.setPreviousSibling(ps);
                    n.setPreviousSibling(null);
                    n.setNextSibling(null);
                    --this.children;
                    return n;
                }
                o = (ExtendedNode)o.getNextSibling();
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(n.getNodeType()), n.getNodeName()});
        }
    }

    protected class ElementsByTagNameNS
    implements NodeList {
        protected Node[] table;
        protected int size = -1;
        protected String namespaceURI;
        protected String localName;

        public ElementsByTagNameNS(String ns, String ln) {
            this.namespaceURI = ns;
            this.localName = ln;
        }

        public Node item(int index) {
            if (this.size == -1) {
                this.initialize();
            }
            if (this.table == null || index < 0 || index > this.size) {
                return null;
            }
            return this.table[index];
        }

        public int getLength() {
            if (this.size == -1) {
                this.initialize();
            }
            return this.size;
        }

        public void invalidate() {
            this.size = -1;
        }

        protected void append(Node n) {
            if (this.table == null) {
                this.table = new Node[11];
            } else if (this.size == this.table.length - 1) {
                Node[] t = new Node[this.table.length * 2 + 1];
                int i = 0;
                while (i < this.size) {
                    t[i] = this.table[i];
                    ++i;
                }
                this.table = t;
            }
            this.table[this.size++] = n;
        }

        protected void initialize() {
            this.size = 0;
            Node n = AbstractParentNode.this.getFirstChild();
            while (n != null) {
                this.initialize(n);
                n = n.getNextSibling();
            }
        }

        private void initialize(Node node) {
            if (node.getNodeType() == 1) {
                String nm;
                String ns = node.getNamespaceURI();
                String string = nm = ns == null ? node.getNodeName() : node.getLocalName();
                if (this.nsMatch(this.namespaceURI, node.getNamespaceURI()) && (this.localName.equals("*") || this.localName.equals(nm))) {
                    this.append(node);
                }
            }
            Node n = node.getFirstChild();
            while (n != null) {
                this.initialize(n);
                n = n.getNextSibling();
            }
        }

        private boolean nsMatch(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            if (s1.equals("*")) {
                return true;
            }
            return s1.equals(s2);
        }
    }

    protected class ElementsByTagName
    implements NodeList {
        protected Node[] table;
        protected int size = -1;
        protected String name;

        public ElementsByTagName(String n) {
            this.name = n;
        }

        public Node item(int index) {
            if (this.size == -1) {
                this.initialize();
            }
            if (this.table == null || index < 0 || index >= this.size) {
                return null;
            }
            return this.table[index];
        }

        public int getLength() {
            if (this.size == -1) {
                this.initialize();
            }
            return this.size;
        }

        public void invalidate() {
            this.size = -1;
        }

        protected void append(Node n) {
            if (this.table == null) {
                this.table = new Node[11];
            } else if (this.size == this.table.length - 1) {
                Node[] t = new Node[this.table.length * 2 + 1];
                int i = 0;
                while (i < this.size) {
                    t[i] = this.table[i];
                    ++i;
                }
                this.table = t;
            }
            this.table[this.size++] = n;
        }

        protected void initialize() {
            this.size = 0;
            Node n = AbstractParentNode.this.getFirstChild();
            while (n != null) {
                this.initialize(n);
                n = n.getNextSibling();
            }
        }

        private void initialize(Node node) {
            if (node.getNodeType() == 1) {
                String nm = node.getNodeName();
                if (this.name.equals("*") || this.name.equals(nm)) {
                    this.append(node);
                }
            }
            Node n = node.getFirstChild();
            while (n != null) {
                this.initialize(n);
                n = n.getNextSibling();
            }
        }
    }
}

