/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.util.List;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;

public class GVTTreeWalker {
    protected GraphicsNode gvtRoot;
    protected GraphicsNode currentNode;

    public GVTTreeWalker(GraphicsNode gvtRoot) {
        this.gvtRoot = gvtRoot;
        this.currentNode = gvtRoot;
    }

    public GraphicsNode getRoot() {
        return this.gvtRoot;
    }

    public void setCurrentGraphicsNode(GraphicsNode node) {
        if (node.getRoot() != this.gvtRoot) {
            throw new IllegalArgumentException("The node " + node + " is not part of the document " + this.gvtRoot);
        }
        this.currentNode = node;
    }

    public GraphicsNode getCurrentGraphicsNode() {
        return this.currentNode;
    }

    public GraphicsNode previousGraphicsNode() {
        GraphicsNode result = this.getPreviousGraphicsNode(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public GraphicsNode nextGraphicsNode() {
        GraphicsNode result = this.getNextGraphicsNode(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public GraphicsNode parentGraphicsNode() {
        CompositeGraphicsNode result = this.currentNode.getParent();
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public GraphicsNode getNextSibling() {
        GraphicsNode result = GVTTreeWalker.getNextSibling(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public GraphicsNode getPreviousSibling() {
        GraphicsNode result = GVTTreeWalker.getPreviousSibling(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public GraphicsNode firstChild() {
        GraphicsNode result = GVTTreeWalker.getFirstChild(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public GraphicsNode lastChild() {
        GraphicsNode result = GVTTreeWalker.getLastChild(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    private GraphicsNode getNextGraphicsNode(GraphicsNode node) {
        if (node == null) {
            return null;
        }
        GraphicsNode n = GVTTreeWalker.getFirstChild(node);
        if (n != null) {
            return n;
        }
        n = GVTTreeWalker.getNextSibling(node);
        if (n != null) {
            return n;
        }
        n = node;
        while ((n = n.getParent()) != null && n != this.gvtRoot) {
            GraphicsNode t = GVTTreeWalker.getNextSibling(n);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private GraphicsNode getPreviousGraphicsNode(GraphicsNode node) {
        if (node == null) {
            return null;
        }
        if (node == this.gvtRoot) {
            return null;
        }
        n = GVTTreeWalker.getPreviousSibling(node);
        if (n != null) ** GOTO lbl9
        return node.getParent();
lbl-1000:
        // 1 sources

        {
            n = var3_3;
lbl9:
            // 2 sources

            ** while ((t = GVTTreeWalker.getLastChild((GraphicsNode)n)) != null)
        }
lbl10:
        // 1 sources

        return n;
    }

    private static GraphicsNode getLastChild(GraphicsNode node) {
        if (!(node instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode parent = (CompositeGraphicsNode)node;
        List children = parent.getChildren();
        if (children == null) {
            return null;
        }
        if (children.size() >= 1) {
            return (GraphicsNode)children.get(children.size() - 1);
        }
        return null;
    }

    private static GraphicsNode getPreviousSibling(GraphicsNode node) {
        CompositeGraphicsNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        List children = parent.getChildren();
        if (children == null) {
            return null;
        }
        int index = children.indexOf(node);
        if (index - 1 >= 0) {
            return (GraphicsNode)children.get(index - 1);
        }
        return null;
    }

    private static GraphicsNode getFirstChild(GraphicsNode node) {
        if (!(node instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode parent = (CompositeGraphicsNode)node;
        List children = parent.getChildren();
        if (children == null) {
            return null;
        }
        if (children.size() >= 1) {
            return (GraphicsNode)children.get(0);
        }
        return null;
    }

    private static GraphicsNode getNextSibling(GraphicsNode node) {
        CompositeGraphicsNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        List children = parent.getChildren();
        if (children == null) {
            return null;
        }
        int index = children.indexOf(node);
        if (index + 1 < children.size()) {
            return (GraphicsNode)children.get(index + 1);
        }
        return null;
    }
}

