/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.GraphicsNodeChangeAdapter;
import org.apache.batik.gvt.event.GraphicsNodeChangeEvent;

public class UpdateTracker
extends GraphicsNodeChangeAdapter {
    Map dirtyNodes = null;
    Map fromBounds = new HashMap();
    Map toBounds = new HashMap();

    public boolean hasChanged() {
        return this.dirtyNodes != null;
    }

    public List getDirtyAreas() {
        if (this.dirtyNodes == null) {
            return null;
        }
        LinkedList<Rectangle2D> ret = new LinkedList<Rectangle2D>();
        Set keys = this.dirtyNodes.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            AffineTransform nat;
            WeakReference gnWRef = (WeakReference)i.next();
            GraphicsNode gn = (GraphicsNode)gnWRef.get();
            if (gn == null) continue;
            AffineTransform oat = (AffineTransform)this.dirtyNodes.get(gnWRef);
            Rectangle2D srcORgn = (Rectangle2D)this.fromBounds.remove(gnWRef);
            Rectangle2D srcNRgn = (Rectangle2D)this.toBounds.remove(gnWRef);
            if (srcNRgn == null) {
                srcNRgn = gn.getBounds();
            }
            if ((nat = gn.getTransform()) != null) {
                nat = nat == null ? null : new AffineTransform(nat);
            }
            Shape oRgn = srcORgn;
            Shape nRgn = srcNRgn;
            while ((gn = gn.getParent()) != null) {
                gnWRef = gn.getWeakReference();
                AffineTransform at = gn.getTransform();
                if (oat != null) {
                    if (at != null) {
                        oat.preConcatenate(at);
                    }
                } else {
                    AffineTransform affineTransform = oat = at == null ? null : new AffineTransform(at);
                }
                if (nat != null) {
                    if (at == null) continue;
                    nat.preConcatenate(at);
                    continue;
                }
                nat = at == null ? null : new AffineTransform(at);
            }
            if (gn != null) continue;
            if (oat != null) {
                oRgn = oat.createTransformedShape(srcORgn);
            }
            if (nat != null) {
                nRgn = nat.createTransformedShape(srcNRgn);
            }
            if (oRgn != null) {
                ret.add((Rectangle2D)oRgn);
            }
            if (nRgn == null) continue;
            ret.add((Rectangle2D)nRgn);
        }
        return ret;
    }

    public void changeStarted(GraphicsNodeChangeEvent gnce) {
        Rectangle2D rgn;
        Rectangle2D r2d;
        GraphicsNode gn = gnce.getGraphicsNode();
        WeakReference gnWRef = gn.getWeakReference();
        boolean doPut = false;
        if (this.dirtyNodes == null) {
            this.dirtyNodes = new HashMap();
            doPut = true;
        } else if (!this.dirtyNodes.containsKey(gnWRef)) {
            doPut = true;
        }
        if (doPut) {
            AffineTransform at = gn.getTransform();
            if (at != null) {
                at = (AffineTransform)at.clone();
            }
            this.dirtyNodes.put(gnWRef, at);
        }
        if ((r2d = gnce.getFrom()) == null) {
            r2d = gn.getBounds();
        }
        if (r2d != null) {
            rgn = (Rectangle2D)this.fromBounds.remove(gnWRef);
            if (rgn != null) {
                r2d.add(rgn);
            }
            this.fromBounds.put(gnWRef, r2d);
        }
        if ((r2d = gnce.getTo()) != null) {
            rgn = (Rectangle2D)this.toBounds.remove(gnWRef);
            if (rgn != null) {
                r2d.add(rgn);
            }
            this.toBounds.put(gnWRef, r2d);
        }
    }

    public void clear() {
        this.dirtyNodes = null;
    }
}

