package co.kuali.coeus.s3.api;

public interface S3FileService {

    /**
     * Creates a file in S3 with server-side encryption.
     * @param s3File the file to create.  The file must be non null, have a non-null InputStream.
     *
     * @return the generated id for the file.
     * @throws IllegalArgumentException if the S3File is not valid.
     * @throws IllegalStateException if the file does not successfully transfer to S3
     */
    String createFile(S3File s3File);

    /**
     * Retrieves a file from S3.
     * @param id the id for the file.  Cannot be blank.
     *
     * @return the file in S3.  Any available metadata will from S3 will be included in the metadata.  This metadata may
     * differ from the metadata used to create the file.  Will return null if the object does not exist.
     * @throws IllegalArgumentException if the id is blank.
     * @throws IllegalStateException if the file does not successfully transfer from S3
     */
    S3File retrieveFile(String id);

    /**
     * Updates a file in S3 with server-side encryption.
     * @param s3File the file to update.  The file must be non null, have a non-null InputStream, and an existing id.
     *
     * @throws IllegalArgumentException if the S3File is not valid.
     * @throws IllegalStateException if the file does not successfully transfer to S3 or if the file does not exist in s3
     */
    void updateFile(S3File s3File);

    /**
     * Delete a file in S3.
     * @param id the id for the file.  Cannot be blank.
     *
     * @throws IllegalArgumentException if the id is blank.
     * @throws IllegalStateException if the file does not successfully delete in S3
     */
    void deleteFile(String id);
}
