package co.kuali.coeus.s3.conv;


import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CsvUtils {
    /** private ctor. */
    private CsvUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    /**
     * Take a csv string and returns each element in a list.  Each element is trimmed and blank elements are removed.
     * Will return an empty collection if csvString is blank.  Will not return null.
     * @param csvString a csv string.
     * @return a list of values
     */
    public static List<String> csvToList(String csvString) {
        if (StringUtils.isBlank(csvString)) {
            return Collections.emptyList();
        }

        return Stream.of(csvString.split(","))
                .map(String::trim)
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.toList());
    }
}
