/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.oracle;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXAResource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXADataSource;

public final class OracleXAConnection
extends StandardXAConnection {
    private XAResource xarsrc = null;
    private static Hashtable txctxs = new Hashtable();

    public OracleXAConnection(StandardXADataSource dataSource, String user, String password) throws SQLException {
        super(dataSource, user, password);
    }

    private OracleXid getOracleXid(Xid xid) throws XAException {
        if (!(xid instanceof OracleXid)) {
            byte[] txctx = (byte[])txctxs.get(xid);
            this.dataSource.log.debug("txctx is " + Arrays.toString(txctx));
            OracleXid newXid = new OracleXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), txctx);
            return newXid;
        }
        return (OracleXid)xid;
    }

    @Override
    public void commit(Xid xid, boolean flag) throws XAException {
        this.dataSource.log.debug("commit:" + Arrays.toString(xid.getGlobalTransactionId()));
        this.xarsrc.commit((Xid)this.getOracleXid(xid), flag);
        this.xaDataSource.freeConnection(xid, false);
        txctxs.remove(xid);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.dataSource.log.debug("end:" + xid.getFormatId() + ":" + Arrays.toString(xid.getGlobalTransactionId()) + ":" + Arrays.toString(xid.getBranchQualifier()) + ":" + flags);
        this.xarsrc.end((Xid)this.getOracleXid(xid), flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.dataSource.log.debug("forget:" + Arrays.toString(xid.getGlobalTransactionId()));
        this.xarsrc.forget((Xid)this.getOracleXid(xid));
        this.xaDataSource.freeConnection(xid, false);
        txctxs.remove(xid);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.dataSource.log.debug("prepare:" + Arrays.toString(xid.getGlobalTransactionId()));
        int res = this.xarsrc.prepare((Xid)this.getOracleXid(xid));
        if (res == 3) {
            this.xaDataSource.freeConnection(xid, false);
            txctxs.remove(xid);
        }
        return res;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.dataSource.log.debug("rollback:" + Arrays.toString(xid.getGlobalTransactionId()));
        this.xarsrc.rollback((Xid)this.getOracleXid(xid));
        this.xaDataSource.freeConnection(xid, false);
        txctxs.remove(xid);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.dataSource.log.debug("start:" + xid.getFormatId() + ":" + Arrays.toString(xid.getGlobalTransactionId()) + ":" + Arrays.toString(xid.getBranchQualifier()) + ":" + flags);
        this.doStart(xid, flags);
        this.xarsrc = new OracleXAResource(this.curCon.con, (oracle.jdbc.xa.OracleXAConnection)new oracle.jdbc.xa.client.OracleXAConnection(this.curCon.con));
        OracleXid oXid = this.getOracleXid(xid);
        this.xarsrc.start((Xid)oXid, flags);
        txctxs.put(xid, oXid.getTxContext());
        this.curCon = null;
        this.con = null;
    }

    @Override
    public boolean isSameRM(XAResource res) throws XAException {
        if (!(res instanceof OracleXAConnection)) {
            this.dataSource.log.debug("isSameRM returning false");
            return false;
        }
        OracleXAConnection ores = (OracleXAConnection)res;
        if (ores.xarsrc.isSameRM(this.xarsrc)) {
            this.dataSource.log.debug("isSameRM returning true");
            return true;
        }
        this.dataSource.log.debug("isSameRM returning false");
        return false;
    }
}

