/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.enhydra.jdbc.standard.StandardPooledConnection;
import org.enhydra.jdbc.util.LRUCache;

public class StandardConnectionPoolDataSource
extends StandardDataSource
implements ConnectionPoolDataSource {
    private Hashtable masterPrepStmtCache = new Hashtable();
    int preparedStmtCacheSize = 16;
    public static final int DEFAULT_PREPAREDSTMTCACHESIZE = 16;

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        this.log.debug("StandardConnectionPoolDataSource:getPooledConnection(0) return a pooled connection");
        return this.getPooledConnection(this.user, this.password);
    }

    @Override
    public synchronized PooledConnection getPooledConnection(String user, String password) throws SQLException {
        this.log.debug("StandardConnectionPoolDataSource:getPooledConnection(2) return a pooled connection");
        StandardPooledConnection spc = new StandardPooledConnection(this, user, password);
        spc.setLogger(this.log);
        return spc;
    }

    public Hashtable getMasterPrepStmtCache() {
        return this.masterPrepStmtCache;
    }

    public int getPreparedStmtCacheSize() {
        return this.preparedStmtCacheSize;
    }

    public void setPreparedStmtCacheSize(int value) {
        this.preparedStmtCacheSize = value;
        if (this.preparedStmtCacheSize <= 0) {
            this.masterPrepStmtCache.clear();
        } else {
            Enumeration e = this.masterPrepStmtCache.elements();
            while (e.hasMoreElements()) {
                ((LRUCache)e.nextElement()).resize(value);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardConnectionPoolDataSource:\n");
        sb.append("     master prepared stmt cache size=<" + this.masterPrepStmtCache.size() + ">\n");
        sb.append("     prepared stmt cache size =<" + this.preparedStmtCacheSize + ">\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

