/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.enhydra.jdbc.core.CoreCallableStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXACallableStatement
extends CoreCallableStatement {
    private StandardXAConnectionHandle con;
    private boolean closed;
    private String sql;
    private int resultSetType;
    private int resultSetConcurrency;
    private int resultSetHoldability;

    StandardXACallableStatement(StandardXAConnectionHandle con, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.con = con;
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.log = con.log;
    }

    private CallableStatement newStatement() throws SQLException {
        if (this.resultSetType == 0 && this.resultSetConcurrency == 0 && this.resultSetHoldability == 0) {
            return this.con.con.prepareCall(this.sql);
        }
        if (this.resultSetHoldability == 0) {
            return this.con.con.prepareCall(this.sql, this.resultSetType, this.resultSetConcurrency);
        }
        return this.con.con.prepareCall(this.sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public synchronized void close() throws SQLException {
        super.close();
        this.closed = true;
    }

    @Override
    public synchronized void preInvoke() throws SQLException {
        block10: {
            if (this.closed) {
                throw new SQLException("Prepare Statement is closed");
            }
            Transaction ntx = null;
            if (this.con.tx == null) {
                try {
                    try {
                        Transaction transaction = ntx = this.con.transactionManager != null ? this.con.transactionManager.getTransaction() : null;
                        if (ntx == null) break block10;
                        this.con.tx = ntx;
                        this.con.xacon.thisAutoCommit = this.con.getAutoCommit();
                        this.con.setAutoCommit(false);
                        try {
                            this.con.tx.enlistResource(this.con.xacon.getXAResource());
                            if (this.cs != null) {
                                this.cs.close();
                                this.cs = null;
                            }
                        }
                        catch (RollbackException n) {
                            throw new SQLException("StandardXAStatement:preInvoke enlistResource exception: " + n.toString());
                        }
                    }
                    catch (SystemException n) {
                        throw new SQLException("StandardXAStatement:preInvoke getTransaction exception: " + n.toString());
                    }
                }
                catch (NullPointerException n) {
                    throw new SQLException("StandardXAStatement:preInvoke should not be used outside an EJBServer: " + n.toString());
                }
            }
        }
        if (this.cs == null) {
            this.cs = this.newStatement();
        }
    }

    @Override
    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }
}

