/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.SQLException;
import java.sql.Statement;
import org.enhydra.jdbc.core.CoreStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXAStatement
extends CoreStatement {
    private StandardXAConnectionHandle con;
    private boolean closed;
    private int resultSetType;
    private int resultSetConcurrency;
    private int resultSetHoldability;

    StandardXAStatement(StandardXAConnectionHandle con, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.con = con;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.log = con.log;
        this.statement = this.newStatement();
    }

    private Statement newStatement() throws SQLException {
        if (this.resultSetType == 0 && this.resultSetConcurrency == 0 && this.resultSetHoldability == 0) {
            return this.con.con.createStatement();
        }
        if (this.resultSetHoldability == 0) {
            return this.con.con.createStatement(this.resultSetType, this.resultSetConcurrency);
        }
        return this.con.con.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public synchronized void close() throws SQLException {
        super.close();
        this.closed = true;
    }

    @Override
    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }
}

