/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplify.model.CustomRule;
import com.amazonaws.services.amplify.model.Platform;
import com.amazonaws.services.amplify.model.ProductionBranch;
import com.amazonaws.services.amplify.model.transform.AppMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App
implements Serializable,
Cloneable,
StructuredPojo {
    private String appId;
    private String appArn;
    private String name;
    private Map<String, String> tags;
    private String description;
    private String repository;
    private String platform;
    private Date createTime;
    private Date updateTime;
    private String iamServiceRoleArn;
    private Map<String, String> environmentVariables;
    private String defaultDomain;
    private Boolean enableBranchAutoBuild;
    private Boolean enableBasicAuth;
    private String basicAuthCredentials;
    private List<CustomRule> customRules;
    private ProductionBranch productionBranch;
    private String buildSpec;

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public App withAppId(String appId) {
        this.setAppId(appId);
        return this;
    }

    public void setAppArn(String appArn) {
        this.appArn = appArn;
    }

    public String getAppArn() {
        return this.appArn;
    }

    public App withAppArn(String appArn) {
        this.setAppArn(appArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public App withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public App withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public App addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public App clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public App withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    public App withRepository(String repository) {
        this.setRepository(repository);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public App withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public App withPlatform(Platform platform) {
        this.platform = platform.toString();
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public App withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public App withUpdateTime(Date updateTime) {
        this.setUpdateTime(updateTime);
        return this;
    }

    public void setIamServiceRoleArn(String iamServiceRoleArn) {
        this.iamServiceRoleArn = iamServiceRoleArn;
    }

    public String getIamServiceRoleArn() {
        return this.iamServiceRoleArn;
    }

    public App withIamServiceRoleArn(String iamServiceRoleArn) {
        this.setIamServiceRoleArn(iamServiceRoleArn);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public App withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.setEnvironmentVariables(environmentVariables);
        return this;
    }

    public App addEnvironmentVariablesEntry(String key, String value) {
        if (null == this.environmentVariables) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (this.environmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environmentVariables.put(key, value);
        return this;
    }

    public App clearEnvironmentVariablesEntries() {
        this.environmentVariables = null;
        return this;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public App withDefaultDomain(String defaultDomain) {
        this.setDefaultDomain(defaultDomain);
        return this;
    }

    public void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
        this.enableBranchAutoBuild = enableBranchAutoBuild;
    }

    public Boolean getEnableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public App withEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
        this.setEnableBranchAutoBuild(enableBranchAutoBuild);
        return this;
    }

    public Boolean isEnableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public void setEnableBasicAuth(Boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public Boolean getEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public App withEnableBasicAuth(Boolean enableBasicAuth) {
        this.setEnableBasicAuth(enableBasicAuth);
        return this;
    }

    public Boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setBasicAuthCredentials(String basicAuthCredentials) {
        this.basicAuthCredentials = basicAuthCredentials;
    }

    public String getBasicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public App withBasicAuthCredentials(String basicAuthCredentials) {
        this.setBasicAuthCredentials(basicAuthCredentials);
        return this;
    }

    public List<CustomRule> getCustomRules() {
        return this.customRules;
    }

    public void setCustomRules(Collection<CustomRule> customRules) {
        if (customRules == null) {
            this.customRules = null;
            return;
        }
        this.customRules = new ArrayList<CustomRule>(customRules);
    }

    public App withCustomRules(CustomRule ... customRules) {
        if (this.customRules == null) {
            this.setCustomRules(new ArrayList<CustomRule>(customRules.length));
        }
        for (CustomRule ele : customRules) {
            this.customRules.add(ele);
        }
        return this;
    }

    public App withCustomRules(Collection<CustomRule> customRules) {
        this.setCustomRules(customRules);
        return this;
    }

    public void setProductionBranch(ProductionBranch productionBranch) {
        this.productionBranch = productionBranch;
    }

    public ProductionBranch getProductionBranch() {
        return this.productionBranch;
    }

    public App withProductionBranch(ProductionBranch productionBranch) {
        this.setProductionBranch(productionBranch);
        return this;
    }

    public void setBuildSpec(String buildSpec) {
        this.buildSpec = buildSpec;
    }

    public String getBuildSpec() {
        return this.buildSpec;
    }

    public App withBuildSpec(String buildSpec) {
        this.setBuildSpec(buildSpec);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppId() != null) {
            sb.append("AppId: ").append(this.getAppId()).append(",");
        }
        if (this.getAppArn() != null) {
            sb.append("AppArn: ").append(this.getAppArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRepository() != null) {
            sb.append("Repository: ").append(this.getRepository()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getUpdateTime() != null) {
            sb.append("UpdateTime: ").append(this.getUpdateTime()).append(",");
        }
        if (this.getIamServiceRoleArn() != null) {
            sb.append("IamServiceRoleArn: ").append(this.getIamServiceRoleArn()).append(",");
        }
        if (this.getEnvironmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.getEnvironmentVariables()).append(",");
        }
        if (this.getDefaultDomain() != null) {
            sb.append("DefaultDomain: ").append(this.getDefaultDomain()).append(",");
        }
        if (this.getEnableBranchAutoBuild() != null) {
            sb.append("EnableBranchAutoBuild: ").append(this.getEnableBranchAutoBuild()).append(",");
        }
        if (this.getEnableBasicAuth() != null) {
            sb.append("EnableBasicAuth: ").append(this.getEnableBasicAuth()).append(",");
        }
        if (this.getBasicAuthCredentials() != null) {
            sb.append("BasicAuthCredentials: ").append(this.getBasicAuthCredentials()).append(",");
        }
        if (this.getCustomRules() != null) {
            sb.append("CustomRules: ").append(this.getCustomRules()).append(",");
        }
        if (this.getProductionBranch() != null) {
            sb.append("ProductionBranch: ").append(this.getProductionBranch()).append(",");
        }
        if (this.getBuildSpec() != null) {
            sb.append("BuildSpec: ").append(this.getBuildSpec());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)obj;
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getAppArn() == null ^ this.getAppArn() == null) {
            return false;
        }
        if (other.getAppArn() != null && !other.getAppArn().equals(this.getAppArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRepository() == null ^ this.getRepository() == null) {
            return false;
        }
        if (other.getRepository() != null && !other.getRepository().equals(this.getRepository())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getUpdateTime() == null ^ this.getUpdateTime() == null) {
            return false;
        }
        if (other.getUpdateTime() != null && !other.getUpdateTime().equals(this.getUpdateTime())) {
            return false;
        }
        if (other.getIamServiceRoleArn() == null ^ this.getIamServiceRoleArn() == null) {
            return false;
        }
        if (other.getIamServiceRoleArn() != null && !other.getIamServiceRoleArn().equals(this.getIamServiceRoleArn())) {
            return false;
        }
        if (other.getEnvironmentVariables() == null ^ this.getEnvironmentVariables() == null) {
            return false;
        }
        if (other.getEnvironmentVariables() != null && !other.getEnvironmentVariables().equals(this.getEnvironmentVariables())) {
            return false;
        }
        if (other.getDefaultDomain() == null ^ this.getDefaultDomain() == null) {
            return false;
        }
        if (other.getDefaultDomain() != null && !other.getDefaultDomain().equals(this.getDefaultDomain())) {
            return false;
        }
        if (other.getEnableBranchAutoBuild() == null ^ this.getEnableBranchAutoBuild() == null) {
            return false;
        }
        if (other.getEnableBranchAutoBuild() != null && !other.getEnableBranchAutoBuild().equals(this.getEnableBranchAutoBuild())) {
            return false;
        }
        if (other.getEnableBasicAuth() == null ^ this.getEnableBasicAuth() == null) {
            return false;
        }
        if (other.getEnableBasicAuth() != null && !other.getEnableBasicAuth().equals(this.getEnableBasicAuth())) {
            return false;
        }
        if (other.getBasicAuthCredentials() == null ^ this.getBasicAuthCredentials() == null) {
            return false;
        }
        if (other.getBasicAuthCredentials() != null && !other.getBasicAuthCredentials().equals(this.getBasicAuthCredentials())) {
            return false;
        }
        if (other.getCustomRules() == null ^ this.getCustomRules() == null) {
            return false;
        }
        if (other.getCustomRules() != null && !other.getCustomRules().equals(this.getCustomRules())) {
            return false;
        }
        if (other.getProductionBranch() == null ^ this.getProductionBranch() == null) {
            return false;
        }
        if (other.getProductionBranch() != null && !other.getProductionBranch().equals(this.getProductionBranch())) {
            return false;
        }
        if (other.getBuildSpec() == null ^ this.getBuildSpec() == null) {
            return false;
        }
        return other.getBuildSpec() == null || other.getBuildSpec().equals(this.getBuildSpec());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getAppArn() == null ? 0 : this.getAppArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRepository() == null ? 0 : this.getRepository().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateTime() == null ? 0 : this.getUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getIamServiceRoleArn() == null ? 0 : this.getIamServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentVariables() == null ? 0 : this.getEnvironmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultDomain() == null ? 0 : this.getDefaultDomain().hashCode());
        hashCode = 31 * hashCode + (this.getEnableBranchAutoBuild() == null ? 0 : this.getEnableBranchAutoBuild().hashCode());
        hashCode = 31 * hashCode + (this.getEnableBasicAuth() == null ? 0 : this.getEnableBasicAuth().hashCode());
        hashCode = 31 * hashCode + (this.getBasicAuthCredentials() == null ? 0 : this.getBasicAuthCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getCustomRules() == null ? 0 : this.getCustomRules().hashCode());
        hashCode = 31 * hashCode + (this.getProductionBranch() == null ? 0 : this.getProductionBranch().hashCode());
        hashCode = 31 * hashCode + (this.getBuildSpec() == null ? 0 : this.getBuildSpec().hashCode());
        return hashCode;
    }

    public App clone() {
        try {
            return (App)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

